/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.io.InputStream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.validation.BytesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.TypedInputStream;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentAdd;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentRemove;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayModel;
import org.jboss.as.server.deploymentoverlay.ReadContentHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentOverlayContentDefinition
extends SimpleResourceDefinition {
    public static final ObjectTypeAttributeDefinition CONTENT_PARAMETER = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("content", new AttributeDefinition[]{((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("input-stream-index", ModelType.INT, true).setValidator((ParameterValidator)new StringLengthValidator(0, true))).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).addArbitraryDescriptor("attached-streams", ModelNode.TRUE)).build(), ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash", ModelType.BYTES, true).setValidator((ParameterValidator)new HashValidator(true))).build(), ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bytes", ModelType.BYTES, true).setValidator((ParameterValidator)new BytesValidator(1, Integer.MAX_VALUE, true))).build(), ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).build()}).setCorrector(ContentCorrector.INSTANCE)).build();
    public static final SimpleAttributeDefinition CONTENT_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("content", ModelType.BYTES, true).setValidator((ParameterValidator)new HashValidator(true))).build();
    public static final SimpleAttributeDefinition STREAM_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"stream", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    private final ContentRepository contentRepository;
    private final OperationStepHandler addHandler;
    private static final SimpleOperationDefinition READ_CONTENT_OP_DEFINITION = new SimpleOperationDefinitionBuilder("read-content", ControllerResolver.getResolver((String[])new String[]{"deployment-overlay", "content"})).setDeprecated(ModelVersion.create((int)5, (int)0, (int)0)).build();
    private static final SimpleOperationDefinition ADD_OP_DEFINITION = new SimpleOperationDefinitionBuilder("add", ControllerResolver.getResolver((String[])new String[]{"deployment-overlay"})).setParameters(new AttributeDefinition[]{CONTENT_PARAMETER}).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CONTENT_ATTRIBUTE};

    public static AttributeDefinition[] attributes() {
        return (AttributeDefinition[])ATTRIBUTES.clone();
    }

    public DeploymentOverlayContentDefinition(ContentRepository contentRepository, DeploymentFileRepository remoteRepository) {
        super(DeploymentOverlayModel.CONTENT_PATH, ControllerResolver.getResolver((String[])new String[]{"deployment-overlay", "content"}), null, (OperationStepHandler)new DeploymentOverlayContentRemove(contentRepository));
        this.contentRepository = contentRepository;
        this.addHandler = new DeploymentOverlayContentAdd(contentRepository, remoteRepository);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute(attr, null);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)STREAM_ATTRIBUTE, (OperationStepHandler)new DeploymentOverlayReadContentHandler(this.contentRepository));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)READ_CONTENT_OP_DEFINITION, (OperationStepHandler)new ReadContentHandler(this.contentRepository));
        resourceRegistration.registerOperationHandler((OperationDefinition)ADD_OP_DEFINITION, this.addHandler);
    }

    private static class DeploymentOverlayReadContentHandler
    implements OperationStepHandler {
        protected final ContentRepository contentRepository;

        public DeploymentOverlayReadContentHandler(ContentRepository contentRepository) {
            this.contentRepository = contentRepository;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource resource = context.getOriginalRootResource();
            for (PathElement element : address) {
                resource = resource.getChild(element);
            }
            byte[] contentHash = resource.getModel().get("content").asBytes();
            try {
                TypedInputStream inputStream = this.contentRepository.readContent(contentHash, "");
                String uuid = context.attachResultStream(inputStream.getContentType(), (InputStream)inputStream);
                context.getResult().get("uuid").set(uuid);
            }
            catch (ExplodedContentException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    private static class ContentCorrector
    implements ParameterCorrector {
        static final ParameterCorrector INSTANCE = new ContentCorrector();

        private ContentCorrector() {
        }

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            if (newValue.isDefined() && newValue.getType() == ModelType.BYTES) {
                ModelNode corrected = new ModelNode();
                corrected.get("hash").set(newValue);
                return corrected;
            }
            return newValue;
        }
    }

    private static class HashValidator
    extends ModelTypeValidator
    implements MinMaxValidator {
        public HashValidator(boolean nillable) {
            super(ModelType.BYTES, nillable);
        }

        public Long getMin() {
            return 20L;
        }

        public Long getMax() {
            return 20L;
        }
    }
}

