/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsat.client;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsat.client.WSATClient;
import jakarta.xml.ws.soap.SOAPFaultException;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.io.IOException;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsat._2006._06.CompletionCoordinatorRPCPortType;
import org.oasis_open.docs.ws_tx.wsat._2006._06.Notification;

public class CompletionCoordinatorRPCClient {
    private static final CompletionCoordinatorRPCClient CLIENT = new CompletionCoordinatorRPCClient();
    private String commitAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Commit";
    private String rollbackAction = "http://docs.oasis-open.org/ws-tx/wsat/2006/06/Rollback";

    private CompletionCoordinatorRPCClient() {
    }

    public boolean sendCommit(W3CEndpointReference endpoint, MAP map) throws SoapFault, IOException {
        CompletionCoordinatorRPCPortType port = this.getPort(endpoint, map, this.commitAction);
        Notification commit = new Notification();
        try {
            return port.commitOperation(commit);
        }
        catch (SOAPFaultException sfe) {
            throw SoapFault11.create(sfe);
        }
    }

    public boolean sendRollback(W3CEndpointReference endpoint, MAP map) throws SoapFault, IOException {
        CompletionCoordinatorRPCPortType port = this.getPort(endpoint, map, this.rollbackAction);
        Notification rollback = new Notification();
        try {
            return port.rollbackOperation(rollback);
        }
        catch (SOAPFaultException sfe) {
            throw SoapFault11.create(sfe);
        }
    }

    public static CompletionCoordinatorRPCClient getClient() {
        return CLIENT;
    }

    private CompletionCoordinatorRPCPortType getPort(W3CEndpointReference endpoint, MAP map, String action) {
        AddressingHelper.installNoneReplyTo(map);
        return WSATClient.getCompletionCoordinatorRPCPort(endpoint, action, map);
    }
}

