/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmp.CMPCertificate;

public class RootCaKeyUpdateContent
extends ASN1Object {
    private final CMPCertificate newWithNew;
    private final CMPCertificate newWithOld;
    private final CMPCertificate oldWithNew;

    public RootCaKeyUpdateContent(CMPCertificate cMPCertificate, CMPCertificate cMPCertificate2, CMPCertificate cMPCertificate3) {
        this.newWithNew = cMPCertificate;
        this.newWithOld = cMPCertificate2;
        this.oldWithNew = cMPCertificate3;
    }

    private RootCaKeyUpdateContent(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException("expected sequence of 1 to 3 elements only");
        }
        CMPCertificate cMPCertificate = null;
        CMPCertificate cMPCertificate2 = null;
        Iterator iterator = aSN1Sequence.iterator();
        CMPCertificate cMPCertificate3 = CMPCertificate.getInstance(iterator.next());
        while (iterator.hasNext()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(iterator.next());
            if (aSN1TaggedObject.getTagNo() == 0) {
                cMPCertificate = CMPCertificate.getInstance(aSN1TaggedObject, true);
                continue;
            }
            if (aSN1TaggedObject.getTagNo() != 1) continue;
            cMPCertificate2 = CMPCertificate.getInstance(aSN1TaggedObject, true);
        }
        this.newWithNew = cMPCertificate3;
        this.newWithOld = cMPCertificate;
        this.oldWithNew = cMPCertificate2;
    }

    public static RootCaKeyUpdateContent getInstance(Object object) {
        if (object instanceof RootCaKeyUpdateContent) {
            return (RootCaKeyUpdateContent)((Object)object);
        }
        if (object != null) {
            return new RootCaKeyUpdateContent(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public CMPCertificate getNewWithNew() {
        return this.newWithNew;
    }

    public CMPCertificate getNewWithOld() {
        return this.newWithOld;
    }

    public CMPCertificate getOldWithNew() {
        return this.oldWithNew;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.newWithNew);
        if (this.newWithOld != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)this.newWithOld));
        }
        if (this.oldWithNew != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)this.oldWithNew));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

