/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.as.network.OutboundConnection;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.discovery.ServiceURL;
import org.xnio.OptionMap;

public class RemotingProfileService
implements Service<RemotingProfileService> {
    private final List<ServiceURL> serviceUrls;
    private final Map<String, RemotingConnectionSpec> remotingConnectionSpecMap;
    private final List<HttpConnectionSpec> httpConnectionSpecs;
    private final InjectedValue<EJBTransportProvider> localTransportProviderInjector = new InjectedValue();

    public RemotingProfileService(List<ServiceURL> serviceUrls, Map<String, RemotingConnectionSpec> remotingConnectionSpecMap, List<HttpConnectionSpec> httpConnectionSpecs) {
        this.serviceUrls = serviceUrls;
        this.remotingConnectionSpecMap = remotingConnectionSpecMap;
        this.httpConnectionSpecs = httpConnectionSpecs;
    }

    public RemotingProfileService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public Collection<RemotingConnectionSpec> getConnectionSpecs() {
        return this.remotingConnectionSpecMap.values();
    }

    public Collection<HttpConnectionSpec> getHttpConnectionSpecs() {
        return this.httpConnectionSpecs;
    }

    public List<ServiceURL> getServiceUrls() {
        return this.serviceUrls;
    }

    public InjectedValue<EJBTransportProvider> getLocalTransportProviderInjector() {
        return this.localTransportProviderInjector;
    }

    public static final class HttpConnectionSpec {
        private final String uri;

        public HttpConnectionSpec(String uri) {
            this.uri = uri;
        }

        public URI getUri() {
            try {
                return new URI(this.uri);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static final class RemotingConnectionSpec {
        private final String connectionName;
        private final InjectedValue<OutboundConnection> injector;
        private final OptionMap connectOptions;
        private final long connectTimeout;

        public RemotingConnectionSpec(String connectionName, InjectedValue<OutboundConnection> injector, OptionMap connectOptions, long connectTimeout) {
            this.connectionName = connectionName;
            this.injector = injector;
            this.connectOptions = connectOptions;
            this.connectTimeout = connectTimeout;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public InjectedValue<OutboundConnection> getInjector() {
            return this.injector;
        }

        public OptionMap getConnectOptions() {
            return this.connectOptions;
        }

        public long getConnectTimeout() {
            return this.connectTimeout;
        }
    }
}

