/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.util.Arrays;
import java.util.Objects;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.spec.PasswordSpec;

public final class OneTimePasswordSpec
implements PasswordSpec {
    private final byte[] hash;
    private final String seed;
    private final int sequenceNumber;

    public OneTimePasswordSpec(byte[] hash, String seed, int sequenceNumber) {
        Assert.checkNotNullParam("hash", hash);
        Assert.checkNotNullParam("seed", seed);
        this.hash = hash;
        this.seed = seed;
        this.sequenceNumber = sequenceNumber;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String getSeed() {
        return this.seed;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean equals(Object other) {
        if (!(other instanceof OneTimePasswordSpec)) {
            return false;
        }
        OneTimePasswordSpec o = (OneTimePasswordSpec)other;
        return Arrays.equals(this.hash, o.hash) && Objects.equals(this.seed, o.seed) && this.sequenceNumber == o.sequenceNumber;
    }

    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.hash), Objects.hashCode(this.seed)), this.sequenceNumber);
    }
}

