/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.Filter;
import org.hibernate.UnknownProfileException;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterImpl;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;

public class LoadQueryInfluencers
implements Serializable {
    public static final LoadQueryInfluencers NONE = new LoadQueryInfluencers();
    private final SessionFactoryImplementor sessionFactory;
    private CascadingFetchProfile enabledCascadingFetchProfile;
    private HashSet<String> enabledFetchProfileNames;
    private HashMap<String, Filter> enabledFilters;
    private final EffectiveEntityGraph effectiveEntityGraph = new EffectiveEntityGraph();
    private Boolean readOnly;

    public LoadQueryInfluencers() {
        this(null, null);
    }

    public LoadQueryInfluencers(SessionFactoryImplementor sessionFactory) {
        this(sessionFactory, null);
    }

    public LoadQueryInfluencers(SessionFactoryImplementor sessionFactory, Boolean readOnly) {
        this.sessionFactory = sessionFactory;
        this.readOnly = readOnly;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromInternalFetchProfile(CascadingFetchProfile profile, Supplier<T> supplier) {
        CascadingFetchProfile previous = this.enabledCascadingFetchProfile;
        this.enabledCascadingFetchProfile = profile;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enabledCascadingFetchProfile = previous;
        }
    }

    public CascadingFetchProfile getEnabledCascadingFetchProfile() {
        return this.enabledCascadingFetchProfile;
    }

    public void setEnabledCascadingFetchProfile(CascadingFetchProfile enabledCascadingFetchProfile) {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("Cannot modify context-less LoadQueryInfluencers");
        }
        this.enabledCascadingFetchProfile = enabledCascadingFetchProfile;
    }

    @Deprecated(since="6.0")
    public String getInternalFetchProfile() {
        return this.getEnabledCascadingFetchProfile().getLegacyName();
    }

    @Deprecated(since="6.0")
    public void setInternalFetchProfile(String internalFetchProfile) {
        this.setEnabledCascadingFetchProfile(CascadingFetchProfile.fromLegacyName(internalFetchProfile));
    }

    public boolean hasEnabledFilters() {
        return this.enabledFilters != null && !this.enabledFilters.isEmpty();
    }

    public Map<String, Filter> getEnabledFilters() {
        if (this.enabledFilters == null) {
            return Collections.emptyMap();
        }
        for (Filter filter : this.enabledFilters.values()) {
            filter.validate();
        }
        return this.enabledFilters;
    }

    public Set<String> getEnabledFilterNames() {
        if (this.enabledFilters == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.enabledFilters.keySet());
    }

    public Filter getEnabledFilter(String filterName) {
        if (this.enabledFilters == null) {
            return null;
        }
        return this.enabledFilters.get(filterName);
    }

    public Filter enableFilter(String filterName) {
        FilterImpl filter = new FilterImpl(this.sessionFactory.getFilterDefinition(filterName));
        if (this.enabledFilters == null) {
            this.enabledFilters = new HashMap();
        }
        this.enabledFilters.put(filterName, filter);
        return filter;
    }

    public void disableFilter(String filterName) {
        if (this.enabledFilters != null) {
            this.enabledFilters.remove(filterName);
        }
    }

    public Object getFilterParameterValue(String filterParameterName) {
        String[] parsed = LoadQueryInfluencers.parseFilterParameterName(filterParameterName);
        if (this.enabledFilters == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        FilterImpl filter = (FilterImpl)this.enabledFilters.get(parsed[0]);
        if (filter == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        return filter.getParameter(parsed[1]);
    }

    public static String[] parseFilterParameterName(String filterParameterName) {
        int dot = filterParameterName.lastIndexOf(46);
        if (dot <= 0) {
            throw new IllegalArgumentException("Invalid filter-parameter name format [" + filterParameterName + "]; expecting {filter-name}.{param-name}");
        }
        String filterName = filterParameterName.substring(0, dot);
        String parameterName = filterParameterName.substring(dot + 1);
        return new String[]{filterName, parameterName};
    }

    public boolean hasEnabledFetchProfiles() {
        return this.enabledFetchProfileNames != null && !this.enabledFetchProfileNames.isEmpty();
    }

    public Set<String> getEnabledFetchProfileNames() {
        return Objects.requireNonNullElse(this.enabledFetchProfileNames, Collections.emptySet());
    }

    private void checkFetchProfileName(String name) {
        if (!this.sessionFactory.containsFetchProfileDefinition(name)) {
            throw new UnknownProfileException(name);
        }
    }

    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        this.checkFetchProfileName(name);
        return this.enabledFetchProfileNames != null && this.enabledFetchProfileNames.contains(name);
    }

    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.checkFetchProfileName(name);
        if (this.enabledFetchProfileNames == null) {
            this.enabledFetchProfileNames = new HashSet();
        }
        this.enabledFetchProfileNames.add(name);
    }

    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.checkFetchProfileName(name);
        if (this.enabledFetchProfileNames != null) {
            this.enabledFetchProfileNames.remove(name);
        }
    }

    public EffectiveEntityGraph getEffectiveEntityGraph() {
        return this.effectiveEntityGraph;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }
}

