/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedInsertHandler;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;

public class PersistentTableInsertStrategy
extends PersistentTableStrategy
implements SqmMultiTableInsertStrategy {
    public static final String SHORT_NAME = "persistent";
    public static final String DROP_ID_TABLES = "hibernate.hql.bulk_id_strategy.persistent.drop_tables";
    public static final String SCHEMA = "hibernate.hql.bulk_id_strategy.persistent.schema";
    public static final String CATALOG = "hibernate.hql.bulk_id_strategy.persistent.catalog";

    public PersistentTableInsertStrategy(TemporaryTable entityTable, SessionFactoryImplementor sessionFactory) {
        super(entityTable, sessionFactory);
    }

    @Override
    public int executeInsert(SqmInsertStatement<?> sqmInsertStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        return new TableBasedInsertHandler(sqmInsertStatement, domainParameterXref, this.getTemporaryTable(), this.getSessionFactory().getJdbcServices().getDialect().getTemporaryTableAfterUseAction(), session -> session.getSessionIdentifier().toString(), this.getSessionFactory()).execute(context);
    }
}

