/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spi;

import org.hibernate.Incubating;
import org.hibernate.spi.DotIdentifierSequence;
import org.hibernate.spi.NavigablePath;

@Incubating
public class EntityIdentifierNavigablePath
extends NavigablePath {
    private final String identifierAttributeName;

    public EntityIdentifierNavigablePath(NavigablePath parent, String identifierAttributeName) {
        super(parent, "{id}");
        this.identifierAttributeName = identifierAttributeName;
    }

    public String getIdentifierAttributeName() {
        return this.identifierAttributeName;
    }

    @Override
    public String getLocalName() {
        return "{id}";
    }

    @Override
    protected boolean localNamesMatch(DotIdentifierSequence otherPath) {
        String otherLocalName = otherPath.getLocalName();
        return otherLocalName.equals(this.getLocalName()) || otherLocalName.equals(this.identifierAttributeName);
    }

    @Override
    protected boolean localNamesMatch(EntityIdentifierNavigablePath otherPath) {
        return super.localNamesMatch(otherPath);
    }
}

