/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class ColumnReference
implements Expression,
Assignable {
    private final String qualifier;
    private final String columnExpression;
    private final boolean isFormula;
    private final String readExpression;
    private final String writeExpression;
    private final JdbcMapping jdbcMapping;

    public ColumnReference(String qualifier, SelectableMapping selectableMapping, SessionFactoryImplementor sessionFactory) {
        this(qualifier, selectableMapping.getSelectionExpression(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getCustomWriteExpression(), selectableMapping.getJdbcMapping(), sessionFactory);
    }

    public ColumnReference(String qualifier, SelectableMapping selectableMapping, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this(qualifier, selectableMapping.getSelectionExpression(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getCustomWriteExpression(), jdbcMapping, sessionFactory);
    }

    public ColumnReference(String qualifier, String columnExpression, boolean isFormula, String customReadExpression, String customWriteExpression, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this.qualifier = StringHelper.nullIfEmpty(qualifier);
        if (isFormula) {
            assert (qualifier != null);
            this.columnExpression = StringHelper.replace(columnExpression, "$PlaceHolder$", qualifier);
        } else {
            this.columnExpression = columnExpression;
        }
        this.isFormula = isFormula;
        if (isFormula) {
            this.readExpression = this.columnExpression;
        } else if (customReadExpression != null) {
            this.readExpression = this.qualifier == null ? StringHelper.replace(customReadExpression, "$PlaceHolder$.", "") : StringHelper.replace(customReadExpression, "$PlaceHolder$", qualifier);
        } else {
            String string = this.readExpression = this.qualifier == null ? this.columnExpression : this.qualifier + "." + this.columnExpression;
        }
        this.writeExpression = isFormula ? null : (customWriteExpression != null ? (this.qualifier == null ? StringHelper.replace(customWriteExpression, "$PlaceHolder$.", "") : StringHelper.replace(customWriteExpression, "$PlaceHolder$", qualifier)) : "?");
        this.jdbcMapping = jdbcMapping;
    }

    public ColumnReference(TableReference tableReference, SelectableMapping selectableMapping, SessionFactoryImplementor sessionFactory) {
        this(tableReference.getIdentificationVariable(), selectableMapping, sessionFactory);
    }

    public ColumnReference(TableReference tableReference, String mapping, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this(tableReference.getIdentificationVariable(), mapping, false, null, null, jdbcMapping, sessionFactory);
    }

    public ColumnReference(TableReference tableReference, String columnExpression, boolean isFormula, String customReadExpression, String customWriteExpression, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this(tableReference.getIdentificationVariable(), columnExpression, isFormula, customReadExpression, customWriteExpression, jdbcMapping, sessionFactory);
    }

    @Override
    public ColumnReference getColumnReference() {
        return this;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    public boolean isColumnExpressionFormula() {
        return this.isFormula;
    }

    public String getExpressionText() {
        return this.readExpression;
    }

    public String renderSqlFragment(SessionFactoryImplementor sessionFactory) {
        return this.getExpressionText();
    }

    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public MappingModelExpressible getExpressionType() {
        return (MappingModelExpressible)((Object)this.jdbcMapping);
    }

    @Override
    public void accept(SqlAstWalker interpreter) {
        interpreter.visitColumnReference(this);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)", this.getClass().getSimpleName(), this.readExpression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnReference that = (ColumnReference)o;
        return this.readExpression.equals(that.readExpression);
    }

    public int hashCode() {
        return this.readExpression.hashCode();
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this);
    }
}

