/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class XmlJdbcType
implements JdbcType {
    public static final XmlJdbcType INSTANCE = new XmlJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 2009;
    }

    public String toString() {
        return "XmlJdbcType";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new XmlValueBinder<X>(javaType, (JdbcType)this);
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getSQLXML(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getSQLXML(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getSQLXML(name), options);
            }

            private X getObject(SQLXML sqlxml, WrapperOptions options) throws SQLException {
                if (sqlxml == null) {
                    return null;
                }
                return options.getSessionFactory().getFastSessionServices().getXmlFormatMapper().fromString(sqlxml.getString(), this.getJavaType(), options);
            }
        };
    }

    protected static class XmlValueBinder<X>
    extends BasicBinder<X> {
        public XmlValueBinder(JavaType<X> javaType, JdbcType jdbcType) {
            super(javaType, jdbcType);
        }

        @Override
        protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
            String xml = options.getSessionFactory().getFastSessionServices().getXmlFormatMapper().toString(value, this.getJavaType(), options);
            SQLXML sqlxml = st.getConnection().createSQLXML();
            sqlxml.setString(xml);
            st.setSQLXML(index, sqlxml);
        }

        @Override
        protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
            String xml = options.getSessionFactory().getFastSessionServices().getXmlFormatMapper().toString(value, this.getJavaType(), options);
            SQLXML sqlxml = st.getConnection().createSQLXML();
            sqlxml.setString(xml);
            st.setSQLXML(name, sqlxml);
        }
    }
}

