/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import org.apache.sshd.client.auth.password.UserAuthPassword;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.core.CoreModuleProperties;

public class JGitPasswordAuthentication
extends UserAuthPassword {
    private int maxAttempts;
    private int attempts;

    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.maxAttempts = Math.max(1, (Integer)CoreModuleProperties.PASSWORD_PROMPTS.getRequired((PropertyResolver)session));
        this.attempts = 0;
    }

    protected String resolveAttemptedPassword(ClientSession session, String service) throws Exception {
        if (++this.attempts > this.maxAttempts) {
            return null;
        }
        return super.resolveAttemptedPassword(session, service);
    }
}

