/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jndi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.apache.activemq.artemis.jndi.JNDIReferenceFactory;

public abstract class JNDIStorable
implements Referenceable {
    protected abstract void buildFromProperties(Properties var1);

    protected abstract void populateProperties(Properties var1);

    synchronized void setProperties(Properties props) {
        this.buildFromProperties(props);
    }

    synchronized Properties getProperties() {
        Properties properties = new Properties();
        this.populateProperties(properties);
        return properties;
    }

    @Override
    public Reference getReference() throws NamingException {
        return JNDIReferenceFactory.createReference(this.getClass().getName(), this);
    }

    public void readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        Properties props = (Properties)in.readObject();
        if (props != null) {
            this.setProperties(props);
        }
    }

    public void writeObject(ObjectOutput out) throws IOException {
        out.writeObject(this.getProperties());
    }
}

