/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.Util;

@MBean(description="Maintains mappings of addresses and their logical names")
public class NAMING
extends Protocol {
    protected Address local_addr;
    protected volatile View view;
    @Property(description="Stagger timeout (in ms). Staggering will be a random timeout in range [0 .. stagger_timeout]")
    protected long stagger_timeout = 500L;

    @Override
    public Object down(Event evt) {
        this.handleEvent(evt);
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        this.handleEvent(evt);
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        Header hdr = (Header)msg.getHeader(this.id);
        if (hdr != null) {
            return this.handleMessage(msg, hdr);
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg2 : batch) {
            Header hdr = (Header)msg2.getHeader(this.id);
            if (hdr == null) continue;
            this.handleMessage(msg2, hdr);
        }
        batch.remove(msg -> msg.getHeader(this.id) != null);
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected Object handleMessage(Message msg, Header hdr) {
        switch (hdr.type) {
            case CACHE_REQ: {
                this.handleCacheRequest(msg.src());
                break;
            }
            case CACHE_RSP: {
                this.handleCacheResponse(msg);
            }
        }
        return null;
    }

    protected void handleCacheRequest(Address sender) {
        int view_size;
        int n = view_size = this.view != null ? this.view.size() : 0;
        if (view_size == 0) {
            return;
        }
        for (Address addr : this.view.getMembersRaw()) {
            String logical_name;
            if (Objects.equals(addr, sender) || (logical_name = NameCache.get(addr)) == null) continue;
            Header hdr = new Header(Type.CACHE_RSP, addr, logical_name);
            Message msg = new Message(sender).putHeader(this.id, hdr);
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: sending %s to %s", this.local_addr, hdr, sender);
            }
            try {
                this.down_prot.down(msg);
            }
            catch (Throwable t) {
                this.log.error("failed sending CACHE_RSP", t);
            }
        }
    }

    protected void handleCacheResponse(Message msg) {
        Header hdr = (Header)msg.getHeader(this.id);
        if (hdr != null && hdr.addr != null && hdr.name != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: received %s from %s", this.local_addr, hdr, msg.src());
            }
            NameCache.add(hdr.addr, hdr.name);
        }
    }

    protected void handleEvent(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View new_view;
                View old_view = this.view;
                this.view = new_view = (View)evt.getArg();
                if (old_view == null) {
                    Util.sleepRandom(0L, this.stagger_timeout);
                    this.multicastOwnMapping();
                    Address coord = new_view.getCoord();
                    if (Objects.equals(this.local_addr, coord)) {
                        return;
                    }
                    Message msg = new Message(coord).setFlag(Message.Flag.OOB).putHeader(this.id, new Header(Type.CACHE_REQ));
                    this.down_prot.down(msg);
                    return;
                }
                if (!(new_view instanceof MergeView)) break;
                Util.sleepRandom(0L, this.stagger_timeout);
                this.multicastOwnMapping();
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
    }

    protected void multicastOwnMapping() {
        String logical_name = NameCache.get(this.local_addr);
        if (logical_name != null) {
            Message msg = new Message(null).setFlag(Message.Flag.OOB).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK).putHeader(this.id, new Header(Type.CACHE_RSP, this.local_addr, logical_name));
            this.down_prot.down(msg);
        }
    }

    public static class Header
    extends org.jgroups.Header {
        protected Type type;
        protected Address addr;
        protected String name;

        public Header() {
        }

        public Header(Type t) {
            this.type = t;
        }

        public Header(Type t, Address addr, String name) {
            this(t);
            this.addr = addr;
            this.name = name;
        }

        @Override
        public Supplier<? extends org.jgroups.Header> create() {
            return Header::new;
        }

        @Override
        public short getMagicId() {
            return 89;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeShort(this.type.ordinal());
            Util.writeAddress(this.addr, out);
            Bits.writeString(this.name, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = Type.values()[in.readShort()];
            this.addr = Util.readAddress(in);
            this.name = Bits.readString(in);
        }

        @Override
        public String toString() {
            return String.format("%s addr=%s name=%s", new Object[]{this.type, this.addr, this.name});
        }

        @Override
        public int serializedSize() {
            return 2 + Util.size(this.addr) + Util.size(this.name);
        }
    }

    public static enum Type {
        CACHE_REQ,
        CACHE_RSP;

    }
}

