/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;

public class JsonbAnnotatedElement<T extends AnnotatedElement> {
    private final Map<Class<? extends Annotation>, LinkedList<AnnotationWrapper<?>>> annotations = new HashMap(4);
    private final T element;

    public JsonbAnnotatedElement(T element) {
        for (Annotation ann : element.getAnnotations()) {
            if (element instanceof Class) {
                this.putAnnotation(ann, false, (Class)element);
                continue;
            }
            this.putAnnotation(ann, false, null);
        }
        this.element = element;
    }

    public T getElement() {
        return this.element;
    }

    public <AT extends Annotation> Optional<AT> getAnnotation(Class<AT> annotationClass) {
        return Optional.ofNullable(this.annotations.get(annotationClass)).map(LinkedList::getFirst).map(AnnotationWrapper::getAnnotation).map(annotationClass::cast);
    }

    public <AT extends Annotation> LinkedList<AnnotationWrapper<?>> getAnnotations(Class<AT> annotationClass) {
        return this.annotations.getOrDefault(annotationClass, new LinkedList());
    }

    public <AT extends Annotation> AnnotationWrapper<AT> getAnnotationWrapper(Class<AT> annotationClass) {
        return this.annotations.get(annotationClass).getFirst();
    }

    public Annotation[] getAnnotations() {
        return (Annotation[])this.annotations.values().stream().flatMap(Collection::stream).map(AnnotationWrapper::getAnnotation).toArray(Annotation[]::new);
    }

    public void putAnnotation(Annotation annotation, boolean inherited, Class<?> definedType) {
        this.annotations.computeIfAbsent(annotation.annotationType(), aClass -> new LinkedList()).add(new AnnotationWrapper<Annotation>(annotation, inherited, definedType));
    }

    public void putAnnotationWrapper(AnnotationWrapper<?> annotationWrapper) {
        this.annotations.computeIfAbsent(annotationWrapper.getAnnotation().annotationType(), aClass -> new LinkedList()).add(annotationWrapper);
    }

    public static final class AnnotationWrapper<T extends Annotation> {
        private final T annotation;
        private final boolean inherited;
        private final Class<?> definedType;

        public AnnotationWrapper(T annotation, boolean inherited, Class<?> definedType) {
            this.annotation = annotation;
            this.inherited = inherited;
            this.definedType = definedType;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public Class<?> getDefinedType() {
            return this.definedType;
        }
    }
}

