/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Weight;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.util.common.AssertionFailure;

public class StoredFieldsCollector
extends SimpleCollector {
    public static final CollectorKey<StoredFieldsCollector> KEY = CollectorKey.create();
    private final NestedDocsProvider nestedDocsProvider;
    private final Weight childrenWeight;
    private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
    private int currentLeafDocBase;
    private int currentLeafLastSeenParentDoc;
    private DocIdSetIterator currentLeafChildDocs;
    private LeafReader currentLeafReader;
    private final Map<Integer, Document> documents = new HashMap<Integer, Document>();

    public static CollectorFactory<StoredFieldsCollector> factory(final ReusableDocumentStoredFieldVisitor storedFieldVisitor, final Set<String> requiredNestedDocumentPathsForStoredFields) {
        return new CollectorFactory<StoredFieldsCollector>(){

            @Override
            public StoredFieldsCollector createCollector(CollectorExecutionContext context) throws IOException {
                NestedDocsProvider nestedDocsProvider = requiredNestedDocumentPathsForStoredFields.isEmpty() ? null : context.createNestedDocsProvider(requiredNestedDocumentPathsForStoredFields);
                return new StoredFieldsCollector(nestedDocsProvider, storedFieldVisitor, context.getIndexSearcher());
            }

            @Override
            public CollectorKey<StoredFieldsCollector> getCollectorKey() {
                return KEY;
            }
        };
    }

    public StoredFieldsCollector(NestedDocsProvider nestedDocsProvider, ReusableDocumentStoredFieldVisitor storedFieldVisitor, IndexSearcher indexSearcher) throws IOException {
        this.childrenWeight = nestedDocsProvider == null ? null : nestedDocsProvider.childDocsWeight(indexSearcher);
        this.nestedDocsProvider = nestedDocsProvider;
        this.storedFieldVisitor = storedFieldVisitor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChildrenCollector{");
        sb.append("documents=").append(this.documents);
        sb.append('}');
        return sb.toString();
    }

    public void collect(int parentDoc) throws IOException {
        if (this.currentLeafChildDocs != null) {
            this.collectChildDocs(parentDoc);
        }
        this.currentLeafReader.document(parentDoc, (StoredFieldVisitor)this.storedFieldVisitor);
        this.documents.put(this.currentLeafDocBase + parentDoc, this.storedFieldVisitor.getDocumentAndReset());
    }

    private void collectChildDocs(int parentDoc) throws IOException {
        if (parentDoc < this.currentLeafLastSeenParentDoc) {
            throw new AssertionFailure("Collector.collect called in unexpected order");
        }
        int firstChildDoc = this.currentLeafChildDocs.docID() > this.currentLeafLastSeenParentDoc ? this.currentLeafChildDocs.docID() : this.currentLeafChildDocs.advance(this.currentLeafLastSeenParentDoc + 1);
        this.currentLeafLastSeenParentDoc = parentDoc;
        if (firstChildDoc > parentDoc) {
            return;
        }
        int childDoc = firstChildDoc;
        while (childDoc < parentDoc) {
            this.currentLeafReader.document(childDoc, (StoredFieldVisitor)this.storedFieldVisitor);
            childDoc = this.currentLeafChildDocs.nextDoc();
        }
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public Document getDocument(int docId) {
        return this.documents.get(docId);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.currentLeafDocBase = context.docBase;
        this.currentLeafLastSeenParentDoc = -1;
        this.currentLeafReader = context.reader();
        this.currentLeafChildDocs = this.nestedDocsProvider == null ? null : this.nestedDocsProvider.childDocs(this.childrenWeight, context);
    }
}

