/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.comparator.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.comparators.DoubleComparator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.DoubleMultiValuesToSingleValuesSource;

public class DoubleValuesSourceComparator
extends DoubleComparator {
    private final DoubleMultiValuesToSingleValuesSource source;

    public DoubleValuesSourceComparator(int numHits, String field, Double missingValue, boolean reversed, int sortPos, DoubleMultiValuesToSingleValuesSource source) {
        super(numHits, field, missingValue, reversed, sortPos);
        this.source = source;
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new DoubleValuesSourceLeafComparator(context);
    }

    private class DoubleValuesSourceLeafComparator
    extends DoubleComparator.DoubleLeafComparator {
        DoubleValuesSourceLeafComparator(LeafReaderContext context) throws IOException {
            super((DoubleComparator)DoubleValuesSourceComparator.this, context);
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return DoubleValuesSourceComparator.this.source.getValues(context, null).getRawDoubleValues();
        }
    }
}

