/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;

public class DefaultProtoStreamReader
extends DefaultProtoStreamOperation
implements ProtoStreamReader,
ProtobufTagMarshaller.ReadContext {
    private final TagReader reader;

    public DefaultProtoStreamReader(ProtobufTagMarshaller.ReadContext context) {
        super((ProtobufTagMarshaller.OperationContext)context);
        this.reader = context.getReader();
    }

    public TagReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readObject(Class<T> targetClass) throws IOException {
        int limit = this.reader.readUInt32();
        int oldLimit = this.reader.pushLimit(limit);
        try {
            ProtobufTagMarshaller marshaller = (ProtobufTagMarshaller)this.getSerializationContext().getMarshaller(targetClass);
            Object result = marshaller instanceof ProtoStreamMarshaller ? ((ProtoStreamMarshaller)marshaller).readFrom(this) : marshaller.read((ProtobufTagMarshaller.ReadContext)this);
            this.reader.checkLastTagWas(0);
            Object object = result;
            return (T)object;
        }
        finally {
            this.reader.popLimit(oldLimit);
        }
    }

    public int pushLimit(int limit) throws IOException {
        return this.reader.pushLimit(limit);
    }

    public void popLimit(int oldLimit) {
        this.reader.popLimit(oldLimit);
    }

    public boolean isAtEnd() throws IOException {
        return this.reader.isAtEnd();
    }

    public int readTag() throws IOException {
        return this.reader.readTag();
    }

    public void checkLastTagWas(int tag) throws IOException {
        this.reader.checkLastTagWas(tag);
    }

    public boolean skipField(int tag) throws IOException {
        return this.reader.skipField(tag);
    }

    public boolean readBool() throws IOException {
        return this.reader.readBool();
    }

    public int readEnum() throws IOException {
        return this.reader.readEnum();
    }

    @Override
    @Deprecated
    public int readInt32() throws IOException {
        return this.reader.readInt32();
    }

    @Override
    @Deprecated
    public int readFixed32() throws IOException {
        return this.reader.readFixed32();
    }

    public int readUInt32() throws IOException {
        return this.reader.readUInt32();
    }

    public int readSInt32() throws IOException {
        return this.reader.readSInt32();
    }

    public int readSFixed32() throws IOException {
        return this.reader.readSFixed32();
    }

    @Override
    @Deprecated
    public long readInt64() throws IOException {
        return this.reader.readInt64();
    }

    @Override
    @Deprecated
    public long readFixed64() throws IOException {
        return this.reader.readFixed64();
    }

    public long readUInt64() throws IOException {
        return this.reader.readUInt64();
    }

    public long readSInt64() throws IOException {
        return this.reader.readSInt64();
    }

    public long readSFixed64() throws IOException {
        return this.reader.readSFixed64();
    }

    public float readFloat() throws IOException {
        return this.reader.readFloat();
    }

    public double readDouble() throws IOException {
        return this.reader.readDouble();
    }

    public byte[] readByteArray() throws IOException {
        return this.reader.readByteArray();
    }

    public ByteBuffer readByteBuffer() throws IOException {
        return this.reader.readByteBuffer();
    }

    public String readString() throws IOException {
        return this.reader.readString();
    }
}

