/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.metrics;

import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadEvents;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.fallback.FallbackEvents;
import io.smallrye.faulttolerance.core.metrics.GeneralMetricsEvents;
import io.smallrye.faulttolerance.core.metrics.MetricsLogger;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.retry.RetryEvents;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsCollector<V>
implements FaultToleranceStrategy<V> {
    final FaultToleranceStrategy<V> delegate;
    final MetricsRecorder metrics;
    final boolean isAsync;
    final boolean hasBulkhead;
    final boolean hasCircuitBreaker;
    final boolean hasRetry;
    final boolean hasTimeout;
    private volatile CircuitBreakerState state;
    private final AtomicLong previousHalfOpenTime = new AtomicLong();
    private volatile long halfOpenStart;
    private final AtomicLong previousClosedTime = new AtomicLong();
    private volatile long closedStart;
    private final AtomicLong previousOpenTime = new AtomicLong();
    private volatile long openStart;
    private final AtomicLong runningExecutions = new AtomicLong();
    private final AtomicLong waitingExecutions = new AtomicLong();

    public MetricsCollector(FaultToleranceStrategy<V> delegate, MetricsRecorder metrics, boolean isAsync, boolean hasBulkhead, boolean hasCircuitBreaker, boolean hasRetry, boolean hasTimeout) {
        this.delegate = delegate;
        this.metrics = metrics;
        this.isAsync = isAsync;
        this.hasBulkhead = hasBulkhead;
        this.hasCircuitBreaker = hasCircuitBreaker;
        this.hasRetry = hasRetry;
        this.hasTimeout = hasTimeout;
        this.state = CircuitBreakerState.CLOSED;
        this.closedStart = System.nanoTime();
        if (hasCircuitBreaker) {
            metrics.registerCircuitBreakerTimeSpentInClosed(() -> this.getTime(CircuitBreakerState.CLOSED, this.closedStart, this.previousClosedTime));
            metrics.registerCircuitBreakerTimeSpentInOpen(() -> this.getTime(CircuitBreakerState.OPEN, this.openStart, this.previousOpenTime));
            metrics.registerCircuitBreakerTimeSpentInHalfOpen(() -> this.getTime(CircuitBreakerState.HALF_OPEN, this.halfOpenStart, this.previousHalfOpenTime));
        }
        if (hasBulkhead) {
            metrics.registerBulkheadExecutionsRunning(this.runningExecutions::get);
            if (isAsync) {
                metrics.registerBulkheadExecutionsWaiting(this.waitingExecutions::get);
            }
        }
    }

    private Long getTime(CircuitBreakerState measuredState, long measuredStateStart, AtomicLong prevMeasuredStateTime) {
        return this.state == measuredState ? prevMeasuredStateTime.get() + System.nanoTime() - measuredStateStart : prevMeasuredStateTime.get();
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        MetricsLogger.LOG.trace("MetricsCollector started");
        try {
            V v = this.doApply(ctx);
            return v;
        }
        finally {
            MetricsLogger.LOG.trace("MetricsCollector finished");
        }
    }

    private V doApply(InvocationContext<V> ctx) throws Exception {
        this.registerMetrics(ctx);
        try {
            V result = this.delegate.apply(ctx);
            ctx.fireEvent(GeneralMetricsEvents.ExecutionFinished.VALUE_RETURNED);
            return result;
        }
        catch (Exception e) {
            ctx.fireEvent(GeneralMetricsEvents.ExecutionFinished.EXCEPTION_THROWN);
            throw e;
        }
    }

    protected final void registerMetrics(InvocationContext<V> ctx) {
        AtomicBoolean fallbackDefined = new AtomicBoolean(false);
        AtomicBoolean fallbackApplied = new AtomicBoolean(false);
        ctx.registerEventHandler(FallbackEvents.Defined.class, ignored -> fallbackDefined.set(true));
        ctx.registerEventHandler(FallbackEvents.Applied.class, ignored -> fallbackApplied.set(true));
        ctx.registerEventHandler(GeneralMetricsEvents.ExecutionFinished.class, event -> this.metrics.executionFinished(event.succeeded, fallbackDefined.get(), fallbackApplied.get()));
        if (this.hasRetry) {
            AtomicBoolean retried = new AtomicBoolean(false);
            ctx.registerEventHandler(RetryEvents.Retried.class, ignored -> {
                this.metrics.retryAttempted();
                retried.set(true);
            });
            ctx.registerEventHandler(RetryEvents.Finished.class, event -> {
                if (RetryEvents.Result.VALUE_RETURNED == event.result) {
                    this.metrics.retryValueReturned(retried.get());
                } else if (RetryEvents.Result.EXCEPTION_NOT_RETRYABLE == event.result) {
                    this.metrics.retryExceptionNotRetryable(retried.get());
                } else if (RetryEvents.Result.MAX_RETRIES_REACHED == event.result) {
                    this.metrics.retryMaxRetriesReached(retried.get());
                } else if (RetryEvents.Result.MAX_DURATION_REACHED == event.result) {
                    this.metrics.retryMaxDurationReached(retried.get());
                }
            });
        }
        if (this.hasTimeout) {
            AtomicLong timeoutStart = new AtomicLong();
            ctx.registerEventHandler(TimeoutEvents.Started.class, ignored -> timeoutStart.set(System.nanoTime()));
            ctx.registerEventHandler(TimeoutEvents.Finished.class, event -> this.metrics.timeoutFinished(event.timedOut, System.nanoTime() - timeoutStart.get()));
        }
        if (this.hasCircuitBreaker) {
            ctx.registerEventHandler(CircuitBreakerEvents.Finished.class, event -> this.metrics.circuitBreakerFinished(event.result));
            ctx.registerEventHandler(CircuitBreakerEvents.StateTransition.class, event -> {
                this.state = event.targetState;
                long now = System.nanoTime();
                switch (event.targetState) {
                    case CLOSED: {
                        this.closedStart = now;
                        this.previousHalfOpenTime.addAndGet(now - this.halfOpenStart);
                        break;
                    }
                    case OPEN: {
                        this.openStart = now;
                        this.previousClosedTime.addAndGet(now - this.closedStart);
                        this.metrics.circuitBreakerMovedToOpen();
                        break;
                    }
                    case HALF_OPEN: {
                        this.halfOpenStart = now;
                        this.previousOpenTime.addAndGet(now - this.openStart);
                    }
                }
            });
        }
        if (this.hasBulkhead) {
            AtomicLong runningStart = new AtomicLong();
            ctx.registerEventHandler(BulkheadEvents.DecisionMade.class, event -> this.metrics.bulkheadDecisionMade(event.accepted));
            ctx.registerEventHandler(BulkheadEvents.StartedRunning.class, ignored -> {
                this.runningExecutions.incrementAndGet();
                runningStart.set(System.nanoTime());
            });
            ctx.registerEventHandler(BulkheadEvents.FinishedRunning.class, ignored -> {
                this.runningExecutions.decrementAndGet();
                this.metrics.updateBulkheadRunningDuration(System.nanoTime() - runningStart.get());
            });
            if (this.isAsync) {
                AtomicLong waitingStart = new AtomicLong();
                ctx.registerEventHandler(BulkheadEvents.StartedWaiting.class, ignored -> {
                    this.waitingExecutions.incrementAndGet();
                    waitingStart.set(System.nanoTime());
                });
                ctx.registerEventHandler(BulkheadEvents.FinishedWaiting.class, ignored -> {
                    this.waitingExecutions.decrementAndGet();
                    this.metrics.updateBulkheadWaitingDuration(System.nanoTime() - waitingStart.get());
                });
            }
        }
    }
}

