/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.securityrequirement;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.ObjectWriter;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;

public class SecurityRequirementWriter {
    private SecurityRequirementWriter() {
    }

    public static void writeSecurityRequirements(ObjectNode parent, List<SecurityRequirement> models) {
        if (models == null) {
            return;
        }
        ArrayNode node = parent.putArray("security");
        for (SecurityRequirement securityRequirement : models) {
            ObjectNode secNode = node.addObject();
            SecurityRequirementWriter.writeSecurityRequirement(secNode, securityRequirement);
        }
    }

    private static void writeSecurityRequirement(ObjectNode node, SecurityRequirement model) {
        if (model == null) {
            return;
        }
        if (model.getSchemes() != null) {
            for (Map.Entry entry : model.getSchemes().entrySet()) {
                ObjectWriter.writeStringArray(node, (List)entry.getValue(), (String)entry.getKey());
            }
        }
    }
}

