/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResourceInvoker;

public class ResteasyRequestWrapper {
    private HttpRequest httpRequest = null;
    private HttpServletRequest httpServletRequest;
    private ResourceInvoker invoker;
    private Integer errorCode = null;
    private String errorMessage;
    private Response abortedResponse;

    public ResteasyRequestWrapper(HttpServletRequest request) throws ServletException, IOException {
        this(request, request.getMethod(), "");
    }

    public ResteasyRequestWrapper(HttpServletRequest request, String httpMethod, String prefix) throws ServletException, IOException {
        this.httpServletRequest = request;
        ResteasyHttpHeaders headers = ServletUtil.extractHttpHeaders((HttpServletRequest)request);
        ResteasyUriInfo uriInfo = ServletUtil.extractUriInfo((HttpServletRequest)request, (String)prefix);
        this.httpRequest = new HttpServletInputMessage(request, null, null, null, headers, uriInfo, httpMethod.toUpperCase(), null);
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public ResourceInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ResourceInvoker invoker) {
        this.invoker = invoker;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setError(Integer errorCode, String errorMessage) {
        this.setErrorCode(errorCode);
        this.setErrorMessage(errorMessage);
    }

    public Response getAbortedResponse() {
        return this.abortedResponse;
    }

    public void setAbortedResponse(Response abortedResponse) {
        this.abortedResponse = abortedResponse;
    }
}

