/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismContext;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.impl.AbstractSecurityContext;
import io.undertow.server.HttpServerExchange;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SecurityContextImpl
extends AbstractSecurityContext
implements AuthenticationMechanismContext {
    private static final RuntimePermission PERMISSION = new RuntimePermission("MODIFY_UNDERTOW_SECURITY_CONTEXT");
    private AuthenticationState authenticationState = AuthenticationState.NOT_ATTEMPTED;
    private final AuthenticationMode authenticationMode;
    private String programaticMechName = "Programatic";
    private Node<AuthenticationMechanism> authMechanisms = null;
    private final IdentityManager identityManager;

    public SecurityContextImpl(HttpServerExchange exchange, IdentityManager identityManager) {
        this(exchange, AuthenticationMode.PRO_ACTIVE, identityManager);
    }

    public SecurityContextImpl(HttpServerExchange exchange, AuthenticationMode authenticationMode, IdentityManager identityManager) {
        super(exchange);
        this.authenticationMode = authenticationMode;
        this.identityManager = identityManager;
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(PERMISSION);
        }
    }

    @Override
    public boolean authenticate() {
        UndertowLogger.SECURITY_LOGGER.debugf("Attempting to authenticate %s, authentication required: %s", this.exchange.getRequestPath(), this.isAuthenticationRequired());
        if (this.authenticationState == AuthenticationState.ATTEMPTED || this.authenticationState == AuthenticationState.CHALLENGE_SENT && !this.exchange.isResponseStarted()) {
            this.authenticationState = AuthenticationState.NOT_ATTEMPTED;
        }
        return !this.authTransition();
    }

    private boolean authTransition() {
        if (this.authTransitionRequired()) {
            switch (this.authenticationState) {
                case NOT_ATTEMPTED: {
                    this.authenticationState = this.attemptAuthentication();
                    break;
                }
                case ATTEMPTED: {
                    this.authenticationState = this.sendChallenges();
                    break;
                }
                default: {
                    throw new IllegalStateException("It should not be possible to reach this.");
                }
            }
            return this.authTransition();
        }
        UndertowLogger.SECURITY_LOGGER.debugf("Authentication result was %s for %s", (Object)this.authenticationState, this.exchange.getRequestPath());
        switch (this.authenticationState) {
            case NOT_ATTEMPTED: 
            case ATTEMPTED: 
            case AUTHENTICATED: {
                return false;
            }
        }
        return true;
    }

    private AuthenticationState attemptAuthentication() {
        return new AuthAttempter(this.authMechanisms, this.exchange).transition();
    }

    private AuthenticationState sendChallenges() {
        UndertowLogger.SECURITY_LOGGER.debugf("Sending authentication challenge for %s", this.exchange);
        return new ChallengeSender(this.authMechanisms, this.exchange).transition();
    }

    private boolean authTransitionRequired() {
        switch (this.authenticationState) {
            case NOT_ATTEMPTED: {
                return this.isAuthenticationRequired() || this.authenticationMode == AuthenticationMode.PRO_ACTIVE;
            }
            case ATTEMPTED: {
                return this.isAuthenticationRequired();
            }
        }
        return false;
    }

    public void setProgramaticMechName(String programaticMechName) {
        this.programaticMechName = programaticMechName;
    }

    @Override
    public void addAuthenticationMechanism(AuthenticationMechanism handler) {
        if (this.authMechanisms == null) {
            this.authMechanisms = new Node<AuthenticationMechanism>(handler);
        } else {
            Node<AuthenticationMechanism> cur = this.authMechanisms;
            while (cur.next != null) {
                cur = cur.next;
            }
            cur.next = new Node<AuthenticationMechanism>(handler);
        }
    }

    @Override
    @Deprecated
    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        LinkedList<AuthenticationMechanism> ret = new LinkedList<AuthenticationMechanism>();
        Node<AuthenticationMechanism> cur = this.authMechanisms;
        while (cur != null) {
            ret.add((AuthenticationMechanism)cur.item);
            cur = cur.next;
        }
        return Collections.unmodifiableList(ret);
    }

    @Override
    @Deprecated
    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }

    @Override
    public boolean login(final String username, final String password) {
        UndertowLogger.SECURITY_LOGGER.debugf("Attempting programatic login for user %s for request %s", username, this.exchange);
        Account account = System.getSecurityManager() == null ? this.identityManager.verify(username, new PasswordCredential(password.toCharArray())) : AccessController.doPrivileged(new PrivilegedAction<Account>(){

            @Override
            public Account run() {
                return SecurityContextImpl.this.identityManager.verify(username, new PasswordCredential(password.toCharArray()));
            }
        });
        if (account == null) {
            return false;
        }
        this.authenticationComplete(account, this.programaticMechName, true);
        this.authenticationState = AuthenticationState.AUTHENTICATED;
        return true;
    }

    @Override
    public void logout() {
        Account authenticatedAccount = this.getAuthenticatedAccount();
        if (authenticatedAccount != null) {
            UndertowLogger.SECURITY_LOGGER.debugf("Logging out user %s for %s", authenticatedAccount.getPrincipal().getName(), this.exchange);
        } else {
            UndertowLogger.SECURITY_LOGGER.debugf("Logout called with no authenticated user in exchange %s", this.exchange);
        }
        super.logout();
        this.authenticationState = AuthenticationState.NOT_ATTEMPTED;
    }

    private static final class Node<T> {
        final T item;
        Node<T> next;

        private Node(T item) {
            this.item = item;
        }
    }

    static enum AuthenticationState {
        NOT_ATTEMPTED,
        ATTEMPTED,
        AUTHENTICATED,
        CHALLENGE_SENT;

    }

    private class ChallengeSender {
        private Node<AuthenticationMechanism> currentMethod;
        private final HttpServerExchange exchange;
        private Integer chosenStatusCode = null;
        private boolean challengeSent = false;

        private ChallengeSender(Node<AuthenticationMechanism> currentMethod, HttpServerExchange exchange) {
            this.exchange = exchange;
            this.currentMethod = currentMethod;
        }

        private AuthenticationState transition() {
            if (this.currentMethod != null) {
                AuthenticationMechanism mechanism = (AuthenticationMechanism)this.currentMethod.item;
                this.currentMethod = this.currentMethod.next;
                AuthenticationMechanism.ChallengeResult result = mechanism.sendChallenge(this.exchange, SecurityContextImpl.this);
                if (result == null) {
                    throw UndertowMessages.MESSAGES.sendChallengeReturnedNull(mechanism);
                }
                if (result.isChallengeSent()) {
                    this.challengeSent = true;
                    Integer desiredCode = result.getDesiredResponseCode();
                    if (desiredCode != null && (this.chosenStatusCode == null || this.chosenStatusCode.equals(200))) {
                        this.chosenStatusCode = desiredCode;
                        if (!this.chosenStatusCode.equals(200) && !this.exchange.isResponseStarted()) {
                            this.exchange.setStatusCode(this.chosenStatusCode);
                        }
                    }
                }
                return this.transition();
            }
            if (!this.exchange.isResponseStarted()) {
                if (this.chosenStatusCode == null) {
                    if (!this.challengeSent) {
                        this.exchange.setStatusCode(403);
                    }
                } else if (this.chosenStatusCode.equals(200)) {
                    this.exchange.setStatusCode(this.chosenStatusCode);
                }
            }
            return AuthenticationState.CHALLENGE_SENT;
        }
    }

    private class AuthAttempter {
        private Node<AuthenticationMechanism> currentMethod;
        private final HttpServerExchange exchange;

        private AuthAttempter(Node<AuthenticationMechanism> currentMethod, HttpServerExchange exchange) {
            this.exchange = exchange;
            this.currentMethod = currentMethod;
        }

        private AuthenticationState transition() {
            if (this.currentMethod != null) {
                AuthenticationMechanism mechanism = (AuthenticationMechanism)this.currentMethod.item;
                this.currentMethod = this.currentMethod.next;
                AuthenticationMechanism.AuthenticationMechanismOutcome outcome = mechanism.authenticate(this.exchange, SecurityContextImpl.this);
                if (UndertowLogger.SECURITY_LOGGER.isDebugEnabled()) {
                    UndertowLogger.SECURITY_LOGGER.debugf("Authentication outcome was %s with method %s for %s", (Object)outcome, mechanism, this.exchange.getRequestURI());
                    if (UndertowLogger.SECURITY_LOGGER.isTraceEnabled()) {
                        UndertowLogger.SECURITY_LOGGER.tracef("Contents of exchange after authentication attempt is %s", this.exchange);
                    }
                }
                if (outcome == null) {
                    throw UndertowMessages.MESSAGES.authMechanismOutcomeNull();
                }
                switch (outcome) {
                    case AUTHENTICATED: {
                        return AuthenticationState.AUTHENTICATED;
                    }
                    case NOT_AUTHENTICATED: {
                        SecurityContextImpl.this.setAuthenticationRequired();
                        return AuthenticationState.ATTEMPTED;
                    }
                    case NOT_ATTEMPTED: {
                        return this.transition();
                    }
                }
                throw new IllegalStateException();
            }
            return AuthenticationState.ATTEMPTED;
        }
    }
}

