/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.Assert;

public abstract class MessageInputStream
extends InputStream
implements DataInput {
    @Override
    public void readFully(byte[] b) throws IOException {
        StreamUtils.readFully(this, b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        StreamUtils.readFully(this, b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)StreamUtils.readInt8(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return StreamUtils.readInt8(this);
    }

    @Override
    public short readShort() throws IOException {
        return (short)StreamUtils.readInt16BE(this);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return StreamUtils.readInt16BE(this);
    }

    @Override
    public char readChar() throws IOException {
        return (char)StreamUtils.readInt16BE(this);
    }

    @Override
    public int readInt() throws IOException {
        return StreamUtils.readInt32BE(this);
    }

    @Override
    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws UnsupportedOperationException {
        throw Assert.unsupported();
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.readUnsignedShort();
        StringBuilder b = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            int y;
            int x = this.readUnsignedByte();
            if (x < 128) {
                b.appendCodePoint(x);
                continue;
            }
            if (192 <= x && x <= 223) {
                if (i++ == len) {
                    throw MessageInputStream.truncated();
                }
                y = this.readUnsignedByte();
                if (128 <= y && y <= 191) {
                    b.appendCodePoint((x & 0x1F) << 6 | y & 0x3F);
                    continue;
                }
                throw MessageInputStream.malformed();
            }
            if (224 <= x && x <= 239) {
                if (i++ == len) {
                    throw MessageInputStream.truncated();
                }
                y = this.readUnsignedByte();
                if (128 <= y && y <= 191) {
                    if (i++ == len) {
                        throw MessageInputStream.truncated();
                    }
                    int z = this.readUnsignedByte();
                    if (128 <= z && z <= 191) {
                        b.appendCodePoint((x & 0xF) << 12 | (y & 0x3F) << 6 | z & 0x3F);
                        continue;
                    }
                    throw MessageInputStream.malformed();
                }
                throw MessageInputStream.malformed();
            }
            throw MessageInputStream.malformed();
        }
        return b.toString();
    }

    private static UTFDataFormatException truncated() {
        return new UTFDataFormatException("Truncated input");
    }

    private static UTFDataFormatException malformed() {
        return new UTFDataFormatException("Malformed input byte");
    }
}

