/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import jakarta.resource.spi.work.DistributableWork;
import jakarta.resource.spi.work.HintsContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkContextProvider;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jboss.jca.core.api.workmanager.DistributableContext;

public class WorkManagerUtil {
    public static boolean isLongRunning(Work work) {
        WorkContextProvider wcProvider;
        List contexts;
        if (work != null && work instanceof WorkContextProvider && (contexts = (wcProvider = (WorkContextProvider)work).getWorkContexts()) != null && contexts.size() > 0) {
            boolean found = false;
            Iterator it = contexts.iterator();
            while (!found && it.hasNext()) {
                HintsContext hc;
                WorkContext wc = (WorkContext)it.next();
                if (!(wc instanceof HintsContext) || !(hc = (HintsContext)wc).getHints().containsKey("jakarta.resource.LongRunning")) continue;
                Serializable value = (Serializable)hc.getHints().get("jakarta.resource.LongRunning");
                if (value != null) {
                    if (value instanceof String) {
                        return Boolean.valueOf((String)((Object)value));
                    }
                    if (!(value instanceof Boolean)) continue;
                    return (Boolean)value;
                }
                return true;
            }
        }
        return false;
    }

    public static Boolean getShouldDistribute(DistributableWork work) {
        List contexts;
        if (work != null && work instanceof WorkContextProvider && (contexts = ((WorkContextProvider)work).getWorkContexts()) != null) {
            for (WorkContext wc : contexts) {
                Serializable value;
                HintsContext hc;
                if (wc instanceof DistributableContext) {
                    DistributableContext dc = (DistributableContext)wc;
                    return dc.getDistribute();
                }
                if (!(wc instanceof HintsContext) || !(hc = (HintsContext)wc).getHints().keySet().contains("org.jboss.jca.core.api.workmanager.Distribute") || (value = (Serializable)hc.getHints().get("org.jboss.jca.core.api.workmanager.Distribute")) == null || !(value instanceof Boolean)) continue;
                return (Boolean)value;
            }
        }
        return null;
    }

    public static String getWorkManager(DistributableWork work) {
        List contexts;
        if (work != null && work instanceof WorkContextProvider && (contexts = ((WorkContextProvider)work).getWorkContexts()) != null) {
            for (WorkContext wc : contexts) {
                Serializable value;
                HintsContext hc;
                if (wc instanceof DistributableContext) {
                    DistributableContext dc = (DistributableContext)wc;
                    return dc.getWorkManager();
                }
                if (!(wc instanceof HintsContext) || !(hc = (HintsContext)wc).getHints().keySet().contains("org.jboss.jca.core.api.workmanager.WorkManager") || (value = (Serializable)hc.getHints().get("org.jboss.jca.core.api.workmanager.WorkManager")) == null || !(value instanceof String)) continue;
                return (String)((Object)value);
            }
        }
        return null;
    }
}

