/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.mod_cluster.CustomLoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderResourceDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterSchema;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemResourceDefinition;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;
import org.wildfly.extension.mod_cluster.SimpleLoadProviderResourceDefinition;
import org.wildfly.extension.mod_cluster.XMLAttribute;
import org.wildfly.extension.mod_cluster.XMLElement;

final class ModClusterSubsystemXMLReader
implements XMLElementReader<List<ModelNode>> {
    private final ModClusterSchema schema;

    ModClusterSubsystemXMLReader(ModClusterSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterSubsystemResourceDefinition.PATH});
        ModelNode subsystemAddOp = Util.createAddOperation((PathAddress)subsystemAddress);
        list.add(subsystemAddOp);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case PROXY: {
                    this.parseProxy(reader, list, subsystemAddress);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProxy(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parent) throws XMLStreamException {
        String name = ModClusterSubsystemXMLReader.require(reader, XMLAttribute.NAME);
        PathAddress address = parent.append(new PathElement[]{ProxyConfigurationResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        list.add(operation);
        int count = reader.getAttributeCount();
        block35: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ADVERTISE_SOCKET: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.ADVERTISE_SOCKET);
                    continue block35;
                }
                case PROXY_URL: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.PROXY_URL);
                    continue block35;
                }
                case ADVERTISE: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.ADVERTISE);
                    continue block35;
                }
                case ADVERTISE_SECURITY_KEY: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.ADVERTISE_SECURITY_KEY);
                    continue block35;
                }
                case EXCLUDED_CONTEXTS: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.EXCLUDED_CONTEXTS);
                    continue block35;
                }
                case AUTO_ENABLE_CONTEXTS: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.AUTO_ENABLE_CONTEXTS);
                    continue block35;
                }
                case STOP_CONTEXT_TIMEOUT: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.STOP_CONTEXT_TIMEOUT);
                    continue block35;
                }
                case SOCKET_TIMEOUT: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.SOCKET_TIMEOUT);
                    continue block35;
                }
                case STICKY_SESSION: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.STICKY_SESSION);
                    continue block35;
                }
                case STICKY_SESSION_REMOVE: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.STICKY_SESSION_REMOVE);
                    continue block35;
                }
                case STICKY_SESSION_FORCE: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.STICKY_SESSION_FORCE);
                    continue block35;
                }
                case WORKER_TIMEOUT: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.WORKER_TIMEOUT);
                    continue block35;
                }
                case MAX_ATTEMPTS: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.MAX_ATTEMPTS);
                    continue block35;
                }
                case FLUSH_PACKETS: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.FLUSH_PACKETS);
                    continue block35;
                }
                case FLUSH_WAIT: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.FLUSH_WAIT);
                    continue block35;
                }
                case PING: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.PING);
                    continue block35;
                }
                case SMAX: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.SMAX);
                    continue block35;
                }
                case TTL: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.TTL);
                    continue block35;
                }
                case NODE_TIMEOUT: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.NODE_TIMEOUT);
                    continue block35;
                }
                case BALANCER: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.BALANCER);
                    continue block35;
                }
                case PROXY_LIST: {
                    if (this.schema.since(ModClusterSchema.MODCLUSTER_6_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ModClusterLogger.ROOT_LOGGER.ignoredAttribute(attribute.getLocalName(), reader.getLocalName());
                    continue block35;
                }
                case LOAD_BALANCING_GROUP: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.LOAD_BALANCING_GROUP);
                    continue block35;
                }
                case SESSION_DRAINING_STRATEGY: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.SESSION_DRAINING_STRATEGY);
                    continue block35;
                }
                case STATUS_INTERVAL: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.STATUS_INTERVAL);
                    continue block35;
                }
                case PROXIES: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.PROXIES);
                    continue block35;
                }
                case SSL_CONTEXT: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.SSL_CONTEXT);
                    continue block35;
                }
                case NAME: {
                    continue block35;
                }
                case LISTENER: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, ProxyConfigurationResourceDefinition.Attribute.LISTENER);
                    continue block35;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block36: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case SIMPLE_LOAD_PROVIDER: {
                    this.parseSimpleLoadProvider(reader, list, address);
                    continue block36;
                }
                case DYNAMIC_LOAD_PROVIDER: {
                    this.parseDynamicLoadProvider(reader, list, address);
                    continue block36;
                }
                case SSL: {
                    ModClusterLogger.ROOT_LOGGER.ignoredElement(element.getLocalName());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block36;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSimpleLoadProvider(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parent) throws XMLStreamException {
        PathAddress address = parent.append(new PathElement[]{SimpleLoadProviderResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTOR: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, SimpleLoadProviderResourceDefinition.Attribute.FACTOR);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        list.add(operation);
    }

    private void parseDynamicLoadProvider(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parent) throws XMLStreamException {
        PathAddress address = parent.append(new PathElement[]{DynamicLoadProviderResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DECAY: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, DynamicLoadProviderResourceDefinition.Attribute.DECAY);
                    continue block9;
                }
                case HISTORY: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, DynamicLoadProviderResourceDefinition.Attribute.HISTORY);
                    continue block9;
                }
                case INITIAL_LOAD: {
                    if (this.schema.since(ModClusterSchema.MODCLUSTER_5_0)) {
                        ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, DynamicLoadProviderResourceDefinition.Attribute.INITIAL_LOAD);
                        continue block9;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(operation);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case LOAD_METRIC: {
                    this.parseLoadMetric(reader, list, address);
                    continue block10;
                }
                case CUSTOM_LOAD_METRIC: {
                    this.parseCustomLoadMetric(reader, list, address);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLoadMetric(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress address) throws XMLStreamException {
        String type = ModClusterSubsystemXMLReader.require(reader, XMLAttribute.TYPE);
        if ("mem".equalsIgnoreCase(type)) {
            ModClusterLogger.ROOT_LOGGER.ignoredElement(type);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
        PathAddress opAddress = address.append(new PathElement[]{LoadMetricResourceDefinition.pathElement(type)});
        ModelNode operation = Util.createAddOperation((PathAddress)opAddress);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, LoadMetricResourceDefinition.Attribute.TYPE);
                    continue block5;
                }
                case CAPACITY: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, LoadMetricResourceDefinition.SharedAttribute.CAPACITY);
                    continue block5;
                }
                case WEIGHT: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, LoadMetricResourceDefinition.SharedAttribute.WEIGHT);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModClusterSubsystemXMLReader.readProperties(reader, operation);
        list.add(operation);
    }

    private void parseCustomLoadMetric(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress address) throws XMLStreamException {
        String type = ModClusterSubsystemXMLReader.require(reader, XMLAttribute.CLASS);
        PathAddress opAddress = address.append(new PathElement[]{CustomLoadMetricResourceDefinition.pathElement(type)});
        ModelNode operation = Util.createAddOperation((PathAddress)opAddress);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            XMLAttribute attribute = XMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, CustomLoadMetricResourceDefinition.Attribute.CLASS);
                    continue block6;
                }
                case CAPACITY: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, LoadMetricResourceDefinition.SharedAttribute.CAPACITY);
                    continue block6;
                }
                case MODULE: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, CustomLoadMetricResourceDefinition.Attribute.MODULE);
                    continue block6;
                }
                case WEIGHT: {
                    ModClusterSubsystemXMLReader.readAttribute(reader, i, operation, LoadMetricResourceDefinition.SharedAttribute.WEIGHT);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModClusterSubsystemXMLReader.readProperties(reader, operation);
        list.add(operation);
    }

    private static String require(XMLExtendedStreamReader reader, XMLAttribute attribute) throws XMLStreamException {
        String value = reader.getAttributeValue(null, attribute.getLocalName());
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attribute.getLocalName()});
        }
        return value;
    }

    private static void readProperties(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Property property = ParseUtils.readProperty((XMLExtendedStreamReader)reader, (boolean)true);
                    operation.get(LoadMetricResourceDefinition.SharedAttribute.PROPERTY.getName()).get(property.getName()).set(property.getValue());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void readAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation, Attribute attribute) throws XMLStreamException {
        ModClusterSubsystemXMLReader.setAttribute(reader, reader.getAttributeValue(index), operation, attribute);
    }

    private static void setAttribute(XMLExtendedStreamReader reader, String value, ModelNode operation, Attribute attribute) throws XMLStreamException {
        AttributeDefinition definition = (AttributeDefinition)attribute.getDefinition();
        definition.getParser().parseAndSetParameter(definition, value, operation, (XMLStreamReader)reader);
    }
}

