/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.naming.jndi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ConfigurationException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;

public class CorbaUtils {
    private static volatile Properties orbProperties;
    private static Method toStubMethod;
    private static Method connectMethod;
    private static Class corbaStubClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object remoteToCorba(Remote remoteObj, ORB orb) throws ClassNotFoundException, ConfigurationException {
        Class<CorbaUtils> clazz = CorbaUtils.class;
        synchronized (CorbaUtils.class) {
            java.lang.Object stub;
            if (toStubMethod == null) {
                CorbaUtils.initMethodHandles();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                stub = toStubMethod.invoke(null, remoteObj);
            }
            catch (InvocationTargetException e) {
                Throwable realException = e.getTargetException();
                ConfigurationException ce = IIOPLogger.ROOT_LOGGER.problemInvokingPortableRemoteObjectToStub();
                ce.setRootCause(realException);
                throw ce;
            }
            catch (IllegalAccessException e) {
                ConfigurationException ce = IIOPLogger.ROOT_LOGGER.cannotInvokePortableRemoteObjectToStub();
                ce.setRootCause(e);
                throw ce;
            }
            if (!corbaStubClass.isInstance(stub)) {
                return null;
            }
            try {
                connectMethod.invoke(stub, orb);
            }
            catch (InvocationTargetException e) {
                Throwable realException = e.getTargetException();
                if (!(realException instanceof RemoteException)) {
                    ConfigurationException ce = IIOPLogger.ROOT_LOGGER.problemInvokingStubConnect();
                    ce.setRootCause(realException);
                    throw ce;
                }
            }
            catch (IllegalAccessException e) {
                ConfigurationException ce = IIOPLogger.ROOT_LOGGER.cannotInvokeStubConnect();
                ce.setRootCause(e);
                throw ce;
            }
            return (Object)stub;
        }
    }

    public static ORB getOrb(String server, int port, Hashtable env) {
        java.lang.Object applet;
        Properties orbProp;
        if (env != null) {
            orbProp = new Properties();
            Enumeration envProp = env.keys();
            while (envProp.hasMoreElements()) {
                String key = (String)envProp.nextElement();
                java.lang.Object val = env.get(key);
                if (!(val instanceof String)) continue;
                orbProp.put(key, val);
            }
            Enumeration<java.lang.Object> mainProps = orbProperties.keys();
            while (mainProps.hasMoreElements()) {
                String key = (String)mainProps.nextElement();
                java.lang.Object val = orbProperties.get(key);
                if (!(val instanceof String)) continue;
                orbProp.put(key, val);
            }
        } else {
            orbProp = orbProperties;
        }
        if (server != null) {
            orbProp.put("org.omg.CORBA.ORBInitialHost", server);
        }
        if (port >= 0) {
            orbProp.put("org.omg.CORBA.ORBInitialPort", "" + port);
        }
        if (env != null && (applet = env.get("java.naming.applet")) != null) {
            return CorbaUtils.initAppletORB(applet, orbProp);
        }
        return ORB.init((String[])new String[0], (Properties)orbProp);
    }

    private static ORB initAppletORB(java.lang.Object applet, Properties orbProp) {
        try {
            Class<?> appletClass = Class.forName("java.applet.Applet", true, null);
            if (!appletClass.isInstance(applet)) {
                throw new ClassCastException(applet.getClass().getName());
            }
            Method method = ORB.class.getMethod("init", appletClass, Properties.class);
            return (ORB)method.invoke(null, applet, orbProp);
        }
        catch (ClassNotFoundException e) {
            throw new ClassCastException(applet.getClass().getName());
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((java.lang.Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((java.lang.Object)e);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((java.lang.Object)iae);
        }
    }

    private static void initMethodHandles() throws ClassNotFoundException {
        corbaStubClass = Class.forName("javax.rmi.CORBA.Stub");
        try {
            connectMethod = corbaStubClass.getMethod("connect", ORB.class);
        }
        catch (NoSuchMethodException e) {
            throw IIOPLogger.ROOT_LOGGER.noMethodDefForStubConnect();
        }
        Class<?> proClass = Class.forName("javax.rmi.PortableRemoteObject");
        try {
            toStubMethod = proClass.getMethod("toStub", Remote.class);
        }
        catch (NoSuchMethodException e) {
            throw IIOPLogger.ROOT_LOGGER.noMethodDefForPortableRemoteObjectToStub();
        }
    }

    public static Properties getOrbProperties() {
        return orbProperties;
    }

    public static void setOrbProperties(Properties orbProperties) {
        CorbaUtils.orbProperties = orbProperties;
    }

    static {
        toStubMethod = null;
        connectMethod = null;
        corbaStubClass = null;
    }
}

