/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.Optional;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public class LuceneNumericRangePredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneNumericRangePredicate(Builder<?, ?> builder) {
        super(builder);
    }

    private static class Builder<F, E extends Number>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements RangePredicateBuilder {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private Range<E> range;

        Builder(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.codec = codec;
        }

        public void range(Range<?> range, ValueConvert convertLowerBound, ValueConvert convertUpperBound) {
            this.range = this.convertAndEncode(this.codec, range, convertLowerBound, convertUpperBound);
        }

        public SearchPredicate build() {
            return new LuceneNumericRangePredicate(this);
        }

        @Override
        protected Query buildQuery() {
            LuceneNumericDomain<E> domain = this.codec.getDomain();
            return domain.createRangeQuery(this.absoluteFieldPath, Builder.getLowerValue(domain, this.range.lowerBoundValue(), this.range.lowerBoundInclusion()), Builder.getUpperValue(domain, this.range.upperBoundValue(), this.range.upperBoundInclusion()));
        }

        private static <E extends Number> E getLowerValue(LuceneNumericDomain<E> domain, Optional<E> boundValueOptional, RangeBoundInclusion inclusion) {
            if (!boundValueOptional.isPresent()) {
                return domain.getMinValue();
            }
            Number boundValue = (Number)boundValueOptional.get();
            return (E)(RangeBoundInclusion.EXCLUDED.equals((Object)inclusion) ? (Number)domain.getNextValue(boundValue) : (Number)boundValue);
        }

        private static <E extends Number> E getUpperValue(LuceneNumericDomain<E> domain, Optional<E> boundValueOptional, RangeBoundInclusion inclusion) {
            if (!boundValueOptional.isPresent()) {
                return domain.getMaxValue();
            }
            Number boundValue = (Number)boundValueOptional.get();
            return (E)(RangeBoundInclusion.EXCLUDED.equals((Object)inclusion) ? (Number)domain.getPreviousValue(boundValue) : (Number)boundValue);
        }
    }

    public static class Factory<F, E extends Number>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<RangePredicateBuilder, F, AbstractLuceneNumericFieldCodec<F, E>> {
        public Factory(AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(codec);
        }

        @Override
        public Builder<F, E> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new Builder((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }
}

