/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.ha.HAManager;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.BroadcastGroupImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.jboss.logging.Logger;

public class ClusterManager
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(ClusterManager.class);
    private ClusterController clusterController;
    private HAManager haManager;
    private final Map<String, BroadcastGroup> broadcastGroups = new HashMap<String, BroadcastGroup>();
    private final Map<String, Bridge> bridges = new HashMap<String, Bridge>();
    private final ExecutorFactory executorFactory;
    private final ActiveMQServer server;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledExecutor;
    private ClusterConnection defaultClusterConnection;
    private final ManagementService managementService;
    private final Configuration configuration;
    private Set<String> protocolIgnoredAddresses = new HashSet<String>();
    private volatile State state = State.STOPPED;
    private final Map<String, ClusterConnection> clusterConnections = new HashMap<String, ClusterConnection>();
    private final Set<ServerLocatorInternal> clusterLocators = new ConcurrentHashSet();
    private final Executor executor;
    private final NodeManager nodeManager;

    public QuorumManager getQuorumManager() {
        return this.clusterController.getQuorumManager();
    }

    public ClusterController getClusterController() {
        return this.clusterController;
    }

    public HAManager getHAManager() {
        return this.haManager;
    }

    public void addClusterChannelHandler(Channel channel, Acceptor acceptorUsed, CoreRemotingConnection remotingConnection, Activation activation) {
        this.clusterController.addClusterChannelHandler(channel, acceptorUsed, remotingConnection, activation);
    }

    public ClusterManager(ExecutorFactory executorFactory, ActiveMQServer server, PostOffice postOffice, ScheduledExecutorService scheduledExecutor, ManagementService managementService, Configuration configuration, NodeManager nodeManager, boolean useQuorumManager) {
        this.executorFactory = executorFactory;
        this.executor = executorFactory.getExecutor();
        this.server = server;
        this.postOffice = postOffice;
        this.scheduledExecutor = scheduledExecutor;
        this.managementService = managementService;
        this.configuration = configuration;
        this.nodeManager = nodeManager;
        this.clusterController = new ClusterController(server, scheduledExecutor, useQuorumManager);
        this.haManager = server.getActivation().getHAManager();
    }

    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("Information on " + this);
        out.println("*******************************************************");
        for (ClusterConnection conn : this.cloneClusterConnections()) {
            out.println(conn.describe());
        }
        out.println("*******************************************************");
        return str.toString();
    }

    public ClusterConnection getDefaultConnection(TransportConfiguration acceptorConfig) {
        if (acceptorConfig == null) {
            return this.defaultClusterConnection;
        }
        if (this.defaultClusterConnection != null && this.defaultClusterConnection.getConnector().isEquivalent(acceptorConfig)) {
            return this.defaultClusterConnection;
        }
        for (ClusterConnection conn : this.cloneClusterConnections()) {
            if (!conn.getConnector().isEquivalent(acceptorConfig)) continue;
            return conn;
        }
        return null;
    }

    public String toString() {
        return "ClusterManagerImpl[server=" + this.server + "]@" + System.identityHashCode(this);
    }

    public String getNodeId() {
        return this.nodeManager.getNodeId().toString();
    }

    public String getBackupGroupName() {
        return this.server.getHAPolicy().getBackupGroupName();
    }

    public String getScaleDownGroupName() {
        return this.server.getHAPolicy().getScaleDownGroupName();
    }

    public synchronized void deploy() throws Exception {
        if (this.state != State.STOPPED) {
            throw new IllegalStateException();
        }
        this.state = State.DEPLOYED;
        for (BroadcastGroupConfiguration broadcastGroupConfiguration : this.configuration.getBroadcastGroupConfigurations()) {
            this.deployBroadcastGroup(broadcastGroupConfiguration);
        }
        for (ClusterConnectionConfiguration clusterConnectionConfiguration : this.configuration.getClusterConfigurations()) {
            this.deployClusterConnection(clusterConnectionConfiguration);
        }
        this.clusterController.start();
    }

    public synchronized void start() throws Exception {
        if (this.state == State.STARTED) {
            return;
        }
        for (BroadcastGroup group : this.broadcastGroups.values()) {
            try {
                group.start();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToStartBroadcastGroup(e, group.getName());
            }
        }
        for (ClusterConnection conn : this.clusterConnections.values()) {
            try {
                conn.start();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToStartClusterConnection(e, conn.getName());
            }
        }
        this.deployConfiguredBridges();
        for (Bridge bridge : this.bridges.values()) {
            try {
                bridge.start();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToStartBridge(e, bridge.getName());
            }
        }
        this.haManager.start();
        this.state = State.STARTED;
    }

    private void deployConfiguredBridges() throws Exception {
        for (BridgeConfiguration config : this.configuration.getBridgeConfigurations()) {
            this.deployBridge(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        this.haManager.stop();
        ClusterManager clusterManager = this;
        synchronized (clusterManager) {
            if (this.state == State.STOPPED || this.state == State.STOPPING) {
                return;
            }
            this.state = State.STOPPING;
            this.clusterController.stop();
            for (BroadcastGroup group : this.broadcastGroups.values()) {
                group.stop();
                this.managementService.unregisterBroadcastGroup(group.getName());
            }
            this.broadcastGroups.clear();
            for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
                clusterConnection.stop();
                this.managementService.unregisterCluster(clusterConnection.getName().toString());
            }
            for (Bridge bridge : this.bridges.values()) {
                bridge.stop();
                this.managementService.unregisterBridge(bridge.getName().toString());
            }
            this.bridges.clear();
        }
        for (ServerLocatorInternal clusterLocator : this.clusterLocators) {
            try {
                clusterLocator.close();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorClosingServerLocator(e, clusterLocator);
            }
        }
        this.clusterLocators.clear();
        this.state = State.STOPPED;
        this.clearClusterConnections();
        this.protocolIgnoredAddresses.clear();
    }

    public void flushExecutor() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        if (!future.await(10000L)) {
            ActiveMQServerLogger.LOGGER.couldNotFlushClusterManager(this.toString());
            this.server.threadDump();
        }
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public Map<String, Bridge> getBridges() {
        return new HashMap<String, Bridge>(this.bridges);
    }

    public Set<ClusterConnection> getClusterConnections() {
        return new HashSet<ClusterConnection>(this.clusterConnections.values());
    }

    public Set<BroadcastGroup> getBroadcastGroups() {
        return new HashSet<BroadcastGroup>(this.broadcastGroups.values());
    }

    public ClusterConnection getClusterConnection(String name) {
        return this.clusterConnections.get(name);
    }

    public void removeClusterLocator(ServerLocatorInternal serverLocator) {
        this.clusterLocators.remove(serverLocator);
    }

    public synchronized boolean deployBridge(BridgeConfiguration config) throws Exception {
        ServerLocatorInternal serverLocator;
        if (config.getName() == null) {
            ActiveMQServerLogger.LOGGER.bridgeNotUnique();
            return false;
        }
        if (config.getQueueName() == null) {
            ActiveMQServerLogger.LOGGER.bridgeNoQueue(config.getName());
            return false;
        }
        if (config.getForwardingAddress() == null) {
            ActiveMQServerLogger.LOGGER.bridgeNoForwardAddress(config.getName());
        }
        if (this.bridges.containsKey(config.getName())) {
            ActiveMQServerLogger.LOGGER.bridgeAlreadyDeployed(config.getName());
            return false;
        }
        Binding binding = this.postOffice.getBinding(new SimpleString(config.getQueueName()));
        if (binding == null) {
            ActiveMQServerLogger.LOGGER.bridgeQueueNotFound(config.getQueueName(), config.getName());
            return false;
        }
        if (this.server.hasBrokerBridgePlugins()) {
            this.server.callBrokerBridgePlugins(plugin -> plugin.beforeDeployBridge(config));
        }
        Queue queue = (Queue)binding.getBindable();
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (discoveryGroupConfiguration == null) {
                ActiveMQServerLogger.LOGGER.bridgeNoDiscoveryGroup(config.getDiscoveryGroupName());
                return false;
            }
            serverLocator = config.isHA() ? (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)discoveryGroupConfiguration) : (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((DiscoveryGroupConfiguration)discoveryGroupConfiguration);
        } else {
            TransportConfiguration[] tcConfigs = this.configuration.getTransportConfigurations(config.getStaticConnectors());
            if (tcConfigs == null) {
                ActiveMQServerLogger.LOGGER.bridgeCantFindConnectors(config.getName());
                return false;
            }
            serverLocator = config.isHA() ? (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs) : (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])tcConfigs);
        }
        serverLocator.setIdentity("Bridge " + config.getName());
        serverLocator.setConfirmationWindowSize(config.getConfirmationWindowSize());
        serverLocator.setReconnectAttempts(0);
        serverLocator.setInitialConnectAttempts(0);
        serverLocator.setRetryInterval(config.getRetryInterval());
        serverLocator.setMaxRetryInterval(config.getMaxRetryInterval());
        serverLocator.setRetryIntervalMultiplier(config.getRetryIntervalMultiplier());
        serverLocator.setClientFailureCheckPeriod(config.getClientFailureCheckPeriod());
        serverLocator.setConnectionTTL(config.getConnectionTTL());
        serverLocator.setBlockOnDurableSend(!config.isUseDuplicateDetection());
        serverLocator.setBlockOnNonDurableSend(!config.isUseDuplicateDetection());
        serverLocator.setMinLargeMessageSize(config.getMinLargeMessageSize());
        serverLocator.setProducerWindowSize(config.getProducerWindowSize());
        serverLocator.setCallTimeout(config.getCallTimeout());
        serverLocator.addIncomingInterceptor((Interceptor)new IncomingInterceptorLookingForExceptionMessage(this, this.executor));
        if (!config.isUseDuplicateDetection()) {
            logger.debug((Object)("Bridge " + config.getName() + " is configured to not use duplicate detecion, it will send messages synchronously"));
        }
        this.clusterLocators.add(serverLocator);
        for (int i = 0; i < config.getConcurrency(); ++i) {
            String name = config.getConcurrency() > 1 ? config.getName() + "-" + i : config.getName();
            BridgeImpl bridge = new BridgeImpl(serverLocator, new BridgeConfiguration(config).setName(name), this.nodeManager.getUUID(), queue, (Executor)this.executorFactory.getExecutor(), this.scheduledExecutor, this.server);
            this.bridges.put(name, bridge);
            this.managementService.registerBridge(bridge);
            bridge.start();
            if (!this.server.hasBrokerBridgePlugins()) continue;
            this.server.callBrokerBridgePlugins(plugin -> plugin.afterDeployBridge(bridge));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyBridge(String name) throws Exception {
        ArrayList<Bridge> bridgesToRemove = new ArrayList<Bridge>();
        ClusterManager clusterManager = this;
        synchronized (clusterManager) {
            for (Bridge bridge : this.bridges.values()) {
                if (!bridge.getName().toString().matches(name + "|" + name + "-\\d+") || (bridge = this.bridges.get(bridge.getName().toString())) == null) continue;
                bridgesToRemove.add(bridge);
            }
            for (Bridge bridgeToRemove : bridgesToRemove) {
                this.bridges.remove(bridgeToRemove.getName().toString());
                bridgeToRemove.stop();
                this.managementService.unregisterBridge(bridgeToRemove.getName().toString());
            }
        }
        for (Bridge bridge : bridgesToRemove) {
            bridge.flushExecutor();
        }
    }

    public void clear() {
        for (Bridge bridge : this.bridges.values()) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
            }
        }
        this.bridges.clear();
        for (ClusterConnection clusterConnection : this.clusterConnections.values()) {
            try {
                clusterConnection.stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToStopClusterConnection(e);
            }
        }
        this.clearClusterConnections();
    }

    public void informClusterOfBackup(String name) {
        ClusterConnection clusterConnection = this.clusterConnections.get(name);
        if (clusterConnection != null) {
            clusterConnection.informClusterOfBackup();
        }
    }

    public ClusterManager addProtocolIgnoredAddress(String ignoredAddress) {
        this.protocolIgnoredAddresses.add(ignoredAddress);
        return this;
    }

    public Collection<String> getProtocolIgnoredAddresses() {
        return this.protocolIgnoredAddresses;
    }

    private void clearClusterConnections() {
        this.clusterConnections.clear();
        this.defaultClusterConnection = null;
    }

    private void deployClusterConnection(ClusterConnectionConfiguration config) throws Exception {
        ClusterConnectionImpl clusterConnection;
        if (!config.validateConfiguration()) {
            return;
        }
        TransportConfiguration connector = config.getTransportConfiguration(this.configuration);
        if (connector == null) {
            return;
        }
        if (this.clusterConnections.containsKey(config.getName())) {
            ActiveMQServerLogger.LOGGER.clusterConnectionAlreadyExists(config.getConnectorName());
            return;
        }
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = config.getDiscoveryGroupConfiguration(this.configuration);
            if (dg == null) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + " Starting a Discovery Group Cluster Connection, name=" + config.getDiscoveryGroupName() + ", dg=" + dg));
            }
            clusterConnection = new ClusterConnectionImpl(this, dg, connector, new SimpleString(config.getName()), new SimpleString(config.getAddress() != null ? config.getAddress() : ""), config.getMinLargeMessageSize(), config.getClientFailureCheckPeriod(), config.getConnectionTTL(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), config.getInitialConnectAttempts(), config.getReconnectAttempts(), config.getCallTimeout(), config.getCallFailoverTimeout(), config.isDuplicateDetection(), config.getMessageLoadBalancingType(), config.getConfirmationWindowSize(), config.getProducerWindowSize(), this.executorFactory, this.server, this.postOffice, this.managementService, this.scheduledExecutor, config.getMaxHops(), this.nodeManager, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), config.isAllowDirectConnectionsOnly(), config.getClusterNotificationInterval(), config.getClusterNotificationAttempts());
            this.clusterController.addClusterConnection(clusterConnection.getName(), dg, config, connector);
        } else {
            Object[] tcConfigs = config.getTransportConfigurations(this.configuration);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + " defining cluster connection towards " + Arrays.toString(tcConfigs)));
            }
            clusterConnection = new ClusterConnectionImpl(this, (TransportConfiguration[])tcConfigs, connector, new SimpleString(config.getName()), new SimpleString(config.getAddress()), config.getMinLargeMessageSize(), config.getClientFailureCheckPeriod(), config.getConnectionTTL(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), config.getInitialConnectAttempts(), config.getReconnectAttempts(), config.getCallTimeout(), config.getCallFailoverTimeout(), config.isDuplicateDetection(), config.getMessageLoadBalancingType(), config.getConfirmationWindowSize(), config.getProducerWindowSize(), this.executorFactory, this.server, this.postOffice, this.managementService, this.scheduledExecutor, config.getMaxHops(), this.nodeManager, this.server.getConfiguration().getClusterUser(), this.server.getConfiguration().getClusterPassword(), config.isAllowDirectConnectionsOnly(), config.getClusterNotificationInterval(), config.getClusterNotificationAttempts());
            this.clusterController.addClusterConnection(clusterConnection.getName(), (TransportConfiguration[])tcConfigs, config, connector);
        }
        if (this.defaultClusterConnection == null) {
            this.defaultClusterConnection = clusterConnection;
            this.clusterController.setDefaultClusterConnectionName(this.defaultClusterConnection.getName());
        }
        this.managementService.registerCluster(clusterConnection, config);
        this.clusterConnections.put(config.getName(), clusterConnection);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ClusterConnection.start at " + clusterConnection), (Throwable)new Exception("trace"));
        }
    }

    private synchronized void deployBroadcastGroup(BroadcastGroupConfiguration config) throws Exception {
        if (this.broadcastGroups.containsKey(config.getName())) {
            ActiveMQServerLogger.LOGGER.broadcastGroupAlreadyExists(config.getName());
            return;
        }
        BroadcastGroup group = this.createBroadcastGroup(config);
        this.managementService.registerBroadcastGroup(group, config);
    }

    private BroadcastGroup createBroadcastGroup(BroadcastGroupConfiguration config) throws Exception {
        BroadcastGroup group = this.broadcastGroups.get(config.getName());
        if (group == null) {
            group = new BroadcastGroupImpl(this.nodeManager, config.getName(), config.getBroadcastPeriod(), this.scheduledExecutor, config.getEndpointFactory());
            for (String connectorInfo : config.getConnectorInfos()) {
                TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorInfo);
                if (connector == null) {
                    this.logWarnNoConnector(connectorInfo, config.getName());
                    return null;
                }
                group.addConnector(connector);
            }
        }
        if (group.size() == 0) {
            this.logWarnNoConnector(config.getConnectorInfos().toString(), group.getName());
            return null;
        }
        this.broadcastGroups.put(config.getName(), group);
        return group;
    }

    private void logWarnNoConnector(String connectorName, String bgName) {
        ActiveMQServerLogger.LOGGER.broadcastGroupNoConnector(connectorName, bgName);
    }

    private synchronized Collection<ClusterConnection> cloneClusterConnections() {
        ArrayList<ClusterConnection> list = new ArrayList<ClusterConnection>(this.clusterConnections.values());
        return list;
    }

    public static class IncomingInterceptorLookingForExceptionMessage
    implements Interceptor {
        private final ClusterManager manager;
        private final Executor executor;

        public IncomingInterceptorLookingForExceptionMessage(ClusterManager manager, Executor executor) {
            this.manager = manager;
            this.executor = executor;
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            ActiveMQExceptionMessage msg;
            ActiveMQException exception;
            if (packet.getType() == 20 && (exception = (msg = (ActiveMQExceptionMessage)packet).getException()).getType() == ActiveMQExceptionType.CLUSTER_SECURITY_EXCEPTION) {
                ActiveMQServerLogger.LOGGER.clusterManagerAuthenticationError(exception.getMessage());
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            manager.stop();
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.failedToStopClusterManager(e);
                        }
                    }
                });
            }
            return true;
        }
    }

    static enum State {
        STOPPED,
        STOPPING,
        DEPLOYED,
        STARTED;

    }
}

