/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.function.BiConsumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.type.MetaType;
import org.hibernate.type.descriptor.java.JavaType;

public class AnyDiscriminatorPart
implements BasicValuedModelPart,
FetchOptions,
SelectableMapping {
    public static final String ROLE_NAME = "{discriminator}";
    private final NavigableRole navigableRole;
    private final DiscriminatedAssociationModelPart declaringType;
    private final String table;
    private final String column;
    private final String columnDefinition;
    private final Long length;
    private final Integer precision;
    private final Integer scale;
    private final boolean nullable;
    private final MetaType metaType;

    public AnyDiscriminatorPart(NavigableRole partRole, DiscriminatedAssociationModelPart declaringType, String table, String column, String columnDefinition, Long length, Integer precision, Integer scale, boolean nullable, MetaType metaType) {
        this.navigableRole = partRole;
        this.declaringType = declaringType;
        this.table = table;
        this.column = column;
        this.columnDefinition = columnDefinition;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
        this.metaType = metaType;
    }

    public MetaType getMetaType() {
        return this.metaType;
    }

    public JdbcMapping jdbcMapping() {
        return (JdbcMapping)((Object)this.metaType.getBaseType());
    }

    @Override
    public String getContainingTableExpression() {
        return this.table;
    }

    @Override
    public String getSelectionExpression() {
        return this.column;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.jdbcMapping().getMappedJavaType();
    }

    @Override
    public String getPartName() {
        return ROLE_NAME;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        Serializable discriminator = this.metaType.disassemble(value, session, value);
        return discriminator;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType.findContainingEntityMapping();
    }

    @Override
    public MappingType getMappedType() {
        return null;
    }

    @Override
    public String getFetchableName() {
        return this.getPartName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachSelectable(SelectableConsumer consumer) {
        return this.forEachSelectable(0, consumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return 1;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SessionFactoryImplementor sessionFactory = sqlAstCreationState.getCreationContext().getSessionFactory();
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableGroup tableGroup = fromClauseAccess.getTableGroup(fetchablePath.getParent().getParent());
        TableReference tableReference = tableGroup.resolveTableReference(fetchablePath, this.table);
        Expression columnReference = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.column), processingState -> new ColumnReference(tableReference, this.column, false, null, null, this.jdbcMapping(), sessionFactory));
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(columnReference, this.jdbcMapping().getMappedJavaType(), fetchParent, sessionFactory.getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, null, fetchTiming, creationState);
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }
}

