/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmMapEntryReference<K, V>
implements SqmSelectableNode<Map.Entry<K, V>>,
Expression<Map.Entry<K, V>>,
SqmExpressible<Map.Entry<K, V>> {
    private final SqmPath<?> mapPath;
    private final NodeBuilder nodeBuilder;
    private final JavaType<Map.Entry<K, V>> mapEntryTypeDescriptor;
    private String explicitAlias;

    public SqmMapEntryReference(SqmPath<?> mapPath, NodeBuilder nodeBuilder) {
        this.mapPath = mapPath;
        this.nodeBuilder = nodeBuilder;
        this.mapEntryTypeDescriptor = nodeBuilder.getDomainModel().getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Map.Entry.class));
    }

    @Override
    public SqmMapEntryReference<K, V> copy(SqmCopyContext context) {
        SqmMapEntryReference existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmMapEntryReference<K, V> path = context.registerCopy(this, new SqmMapEntryReference<K, V>((SqmPath<?>)this.mapPath.copy(context), this.nodeBuilder()));
        return path;
    }

    public String getAlias() {
        return this.explicitAlias;
    }

    public SqmPath<?> getMapPath() {
        return this.mapPath;
    }

    @Override
    public JpaSelection<Map.Entry<K, V>> alias(String name) {
        this.explicitAlias = name;
        return this;
    }

    @Override
    public JavaType<Map.Entry<K, V>> getJavaTypeDescriptor() {
        return this.mapEntryTypeDescriptor;
    }

    @Override
    public JavaType<Map.Entry<K, V>> getNodeJavaType() {
        return this.mapEntryTypeDescriptor;
    }

    @Override
    public JavaType<Map.Entry<K, V>> getExpressibleJavaType() {
        return this.mapEntryTypeDescriptor;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitMapEntryFunction(this);
    }

    @Override
    public void visitSubSelectableNodes(Consumer<SqmSelectableNode<?>> jpaSelectionConsumer) {
        jpaSelectionConsumer.accept(this);
    }

    public boolean isCompoundSelection() {
        return false;
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return Collections.emptyList();
    }

    @Override
    public SqmExpressible<Map.Entry<K, V>> getNodeType() {
        return this;
    }

    @Override
    public Class<Map.Entry<K, V>> getBindableJavaType() {
        return this.getNodeType().getBindableJavaType();
    }

    @Override
    public NodeBuilder nodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("entry(");
        this.mapPath.appendHqlString(sb);
        sb.append(')');
    }

    public Predicate isNull() {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    public Predicate isNotNull() {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    public Predicate in(Object ... values) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    public Predicate in(Expression<?> ... values) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    public Predicate in(Collection<?> values) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    public Predicate in(Expression<Collection<?>> values) {
        throw new UnsupportedOperationException("Whatever JPA");
    }

    public <X> Expression<X> as(Class<X> type) {
        throw new UnsupportedOperationException("Whatever JPA");
    }
}

