/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaQueryGroup;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmQueryGroup<T>
extends SqmQueryPart<T>
implements JpaQueryGroup<T> {
    private final List<SqmQueryPart<T>> queryParts;
    private SetOperator setOperator;

    public SqmQueryGroup(SqmQueryPart<T> queryPart) {
        this(queryPart.nodeBuilder(), null, CollectionHelper.listOf(queryPart));
    }

    public SqmQueryGroup(NodeBuilder nodeBuilder, SetOperator setOperator, List<SqmQueryPart<T>> queryParts) {
        super(nodeBuilder);
        this.setOperator = setOperator;
        this.queryParts = queryParts;
    }

    @Override
    public SqmQueryPart<T> copy(SqmCopyContext context) {
        SqmQueryGroup existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmQueryPart<T>> queryParts = new ArrayList<SqmQueryPart<T>>(this.queryParts.size());
        for (SqmQueryPart<T> queryPart : this.queryParts) {
            queryParts.add((SqmQueryPart<T>)queryPart.copy(context));
        }
        SqmQueryGroup<T> queryGroup = context.registerCopy(this, new SqmQueryGroup<T>(this.nodeBuilder(), this.setOperator, queryParts));
        this.copyTo(queryGroup, context);
        return queryGroup;
    }

    public List<SqmQueryPart<T>> queryParts() {
        return this.queryParts;
    }

    @Override
    public SqmQuerySpec<T> getFirstQuerySpec() {
        return this.queryParts.get(0).getFirstQuerySpec();
    }

    @Override
    public SqmQuerySpec<T> getLastQuerySpec() {
        return this.queryParts.get(this.queryParts.size() - 1).getLastQuerySpec();
    }

    @Override
    public boolean isSimpleQueryPart() {
        return this.setOperator == null && this.queryParts.size() == 1 && this.queryParts.get(0).isSimpleQueryPart();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQueryGroup(this);
    }

    @Override
    public List<SqmQueryPart<T>> getQueryParts() {
        return Collections.unmodifiableList(this.queryParts);
    }

    @Override
    public SetOperator getSetOperator() {
        return this.setOperator;
    }

    @Override
    public void setSetOperator(SetOperator setOperator) {
        if (setOperator == null) {
            throw new IllegalArgumentException();
        }
        this.setOperator = setOperator;
    }

    @Override
    public SqmQueryGroup<T> setSortSpecifications(List<? extends JpaOrder> sortSpecifications) {
        return (SqmQueryGroup)super.setSortSpecifications((List)sortSpecifications);
    }

    @Override
    public SqmQueryGroup<T> setOffset(JpaExpression<?> offset) {
        return (SqmQueryGroup)super.setOffset((JpaExpression)offset);
    }

    @Override
    public SqmQueryGroup<T> setFetch(JpaExpression<?> fetch) {
        return (SqmQueryGroup)super.setFetch((JpaExpression)fetch);
    }

    @Override
    public SqmQueryGroup<T> setFetch(JpaExpression<?> fetch, FetchClauseType fetchClauseType) {
        return (SqmQueryGroup)super.setFetch(fetch, fetchClauseType);
    }

    @Override
    public void validateQueryStructureAndFetchOwners() {
        SqmQuerySpec<T> firstQuerySpec = this.getFirstQuerySpec();
        firstQuerySpec.validateFetchOwners();
        List<SqmSelection<?>> firstSelections = firstQuerySpec.getSelectClause().getSelections();
        int firstSelectionSize = firstSelections.size();
        ArrayList typedNodes = new ArrayList(firstSelectionSize);
        for (int i = 0; i < firstSelectionSize; ++i) {
            typedNodes.add(firstSelections.get(i).getSelectableNode());
        }
        this.validateQueryGroupFetchStructure(typedNodes);
    }

    private void validateQueryGroupFetchStructure(List<? extends SqmTypedNode<?>> typedNodes) {
        int firstSelectionSize = typedNodes.size();
        for (int i = 0; i < this.queryParts.size(); ++i) {
            SqmQueryPart<T> queryPart = this.queryParts.get(i);
            if (queryPart instanceof SqmQueryGroup) {
                ((SqmQueryGroup)queryPart).validateQueryGroupFetchStructure(typedNodes);
                continue;
            }
            SqmQuerySpec querySpec = (SqmQuerySpec)queryPart;
            List<SqmSelection<?>> selections = querySpec.getSelectClause().getSelections();
            if (firstSelectionSize != selections.size()) {
                throw new SemanticException("All query parts in a query group must have the same arity!");
            }
            for (int j = 0; j < firstSelectionSize; ++j) {
                SqmTypedNode<?> firstSqmSelection = typedNodes.get(j);
                JavaType<?> firstJavaType = firstSqmSelection.getNodeJavaType();
                if (firstJavaType != selections.get(j).getNodeJavaType()) {
                    throw new SemanticException("Select items of the same index must have the same java type across all query parts!");
                }
                if (!(firstSqmSelection instanceof SqmFrom)) continue;
                SqmFrom firstFrom = (SqmFrom)firstSqmSelection;
                SqmFrom from = (SqmFrom)selections.get(j).getSelectableNode();
                this.validateFetchesMatch(firstFrom, from);
            }
        }
    }

    private void validateFetchesMatch(SqmFrom<?, ?> firstFrom, SqmFrom<?, ?> from) {
        Iterator<SqmJoin<?, ?>> firstJoinIter = firstFrom.getSqmJoins().iterator();
        Iterator<SqmJoin<?, ?>> joinIter = from.getSqmJoins().iterator();
        while (firstJoinIter.hasNext()) {
            SqmAttributeJoin firstAttrJoin;
            SqmJoin<?, ?> firstSqmJoin = firstJoinIter.next();
            if (!(firstSqmJoin instanceof SqmAttributeJoin) || !(firstAttrJoin = (SqmAttributeJoin)firstSqmJoin).isFetched()) continue;
            SqmAttributeJoin matchingAttrJoin = null;
            while (joinIter.hasNext()) {
                SqmAttributeJoin attrJoin;
                SqmJoin<?, ?> sqmJoin = joinIter.next();
                if (!(sqmJoin instanceof SqmAttributeJoin) || !(attrJoin = (SqmAttributeJoin)sqmJoin).isFetched()) continue;
                matchingAttrJoin = attrJoin;
                break;
            }
            if (matchingAttrJoin == null || firstAttrJoin.getModel() != matchingAttrJoin.getModel()) {
                throw new SemanticException("All query parts in a query group must have the same join fetches in the same order!");
            }
            this.validateFetchesMatch(firstAttrJoin, matchingAttrJoin);
        }
        while (joinIter.hasNext()) {
            SqmAttributeJoin attrJoin;
            SqmJoin<?, ?> sqmJoin = joinIter.next();
            if (!(sqmJoin instanceof SqmAttributeJoin) || !(attrJoin = (SqmAttributeJoin)sqmJoin).isFetched()) continue;
            throw new SemanticException("All query parts in a query group must have the same join fetches in the same order!");
        }
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        SqmQueryGroup.appendQueryPart(this.queryParts.get(0), sb);
        for (int i = 1; i < this.queryParts.size(); ++i) {
            sb.append(' ');
            sb.append(this.setOperator.sqlString());
            sb.append(' ');
            SqmQueryGroup.appendQueryPart(this.queryParts.get(i), sb);
        }
        super.appendHqlString(sb);
    }

    private static void appendQueryPart(SqmQueryPart<?> queryPart, StringBuilder sb) {
        boolean needsParenthesis;
        boolean bl = needsParenthesis = !queryPart.isSimpleQueryPart();
        if (needsParenthesis) {
            sb.append('(');
        }
        queryPart.appendHqlString(sb);
        if (needsParenthesis) {
            sb.append(')');
        }
    }
}

