/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.PersistenceException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.jboss.logging.Logger;

public class AttributeConverterTypeAdapter<T>
extends AbstractSingleColumnStandardBasicType<T> {
    private static final Logger log = Logger.getLogger(AttributeConverterTypeAdapter.class);
    public static final String NAME_PREFIX = "converted::";
    private final String name;
    private final String description;
    private final JavaType<T> domainJtd;
    private final JavaType<?> relationalJtd;
    private final JpaAttributeConverter<T, Object> attributeConverter;
    private final MutabilityPlan<T> mutabilityPlan;
    private final ValueBinder<Object> valueBinder;

    public AttributeConverterTypeAdapter(String name, String description, JpaAttributeConverter<? extends T, ?> attributeConverter, JdbcType std, JavaType<?> relationalJtd, JavaType<T> domainJtd, MutabilityPlan<T> mutabilityPlan) {
        super(std, relationalJtd);
        this.name = name;
        this.description = description;
        this.domainJtd = domainJtd;
        this.relationalJtd = relationalJtd;
        this.attributeConverter = attributeConverter;
        this.mutabilityPlan = mutabilityPlan == null ? attributeConverter.getDomainJavaType().getMutabilityPlan() : mutabilityPlan;
        this.valueBinder = this.getJdbcType().getBinder(relationalJtd);
        log.debugf("Created AttributeConverterTypeAdapter -> %s", (Object)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JavaType<T> getDomainJtd() {
        return this.domainJtd;
    }

    public JavaType<?> getRelationalJtd() {
        return this.relationalJtd;
    }

    public JpaAttributeConverter<? extends T, ?> getAttributeConverter() {
        return this.attributeConverter;
    }

    @Override
    public void nullSafeSet(CallableStatement st, T value, String name, SharedSessionContractImplementor session) throws SQLException {
        AttributeConverter<T, Object> converter = this.attributeConverter.getConverterBean().getBeanInstance();
        Object converted = this.getConvertedValue(converter, value);
        this.valueBinder.bind(st, converted, name, (WrapperOptions)session);
    }

    @Override
    protected void nullSafeSet(PreparedStatement st, T value, int index, WrapperOptions options) throws SQLException {
        AttributeConverter<T, Object> converter = this.attributeConverter.getConverterBean().getBeanInstance();
        Object converted = this.getConvertedValue(converter, value);
        this.valueBinder.bind(st, converted, index, options);
    }

    @Override
    protected MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public boolean isEqual(Object one, Object another) {
        return this.getDomainJtd().areEqual(one, another);
    }

    @Override
    public int getHashCode(Object x) {
        return this.getDomainJtd().extractHashCode(x);
    }

    public String toString() {
        return this.description;
    }

    private Object getConvertedValue(AttributeConverter<T, Object> converter, T value) {
        try {
            return converter.convertToDatabaseColumn(value);
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new PersistenceException("Error attempting to apply AttributeConverter", (Throwable)re);
        }
    }
}

