/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jberet.creation.AbstractArtifactFactory;
import org.jberet.spi.ArtifactFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.ContextHandle;
import org.wildfly.extension.batch.jberet.deployment.WildFlyArtifactFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ArtifactFactoryService
extends AbstractArtifactFactory
implements Service<ArtifactFactory>,
WildFlyArtifactFactory {
    private final InjectedValue<BeanManager> beanManagerInjector = new InjectedValue();
    private final Map<Object, Holder> contexts = Collections.synchronizedMap(new HashMap());
    private volatile BeanManager beanManager;

    public void destroy(Object instance) {
        Holder holder = this.contexts.remove(instance);
        if (holder == null) {
            super.destroy(instance);
        } else if (holder.isDependent()) {
            holder.context.release();
        }
    }

    public Class<?> getArtifactClass(String ref, ClassLoader classLoader) {
        Bean<?> bean = ArtifactFactoryService.getBean(ref, (BeanManager)this.getBeanManager(), classLoader);
        return bean == null ? null : bean.getBeanClass();
    }

    public Object create(String ref, Class<?> cls, ClassLoader classLoader) throws Exception {
        BeanManagerImpl beanManager = this.getBeanManager();
        Bean<?> bean = ArtifactFactoryService.getBean(ref, (BeanManager)beanManager, classLoader);
        if (bean == null) {
            return null;
        }
        CreationalContext context = beanManager.createCreationalContext(bean);
        Object result = beanManager.getReference(bean, (Type)bean.getBeanClass(), context);
        this.contexts.put(result, new Holder(bean, context));
        return result;
    }

    public void start(StartContext context) throws StartException {
        this.beanManager = (BeanManager)this.beanManagerInjector.getOptionalValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        this.beanManager = null;
        Map<Object, Holder> map = this.contexts;
        synchronized (map) {
            for (Holder holder : this.contexts.values()) {
                if (!holder.isDependent()) continue;
                holder.context.release();
            }
            this.contexts.clear();
        }
    }

    public ArtifactFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public ContextHandle createContextHandle() {
        BeanManagerImpl beanManager = this.getBeanManager();
        return () -> {
            if (beanManager == null || beanManager.isContextActive(RequestScoped.class)) {
                return () -> {};
            }
            RequestContext requestContext = (RequestContext)beanManager.instance().select(RequestContext.class, new Annotation[]{UnboundLiteral.INSTANCE}).get();
            requestContext.activate();
            return () -> {
                requestContext.invalidate();
                requestContext.deactivate();
            };
        };
    }

    public InjectedValue<BeanManager> getBeanManagerInjector() {
        return this.beanManagerInjector;
    }

    private BeanManagerImpl getBeanManager() {
        BeanManager beanManager = this.beanManager;
        return beanManager == null ? null : BeanManagerProxy.unwrap((BeanManager)beanManager);
    }

    private static Bean<?> getBean(String ref, BeanManager beanManager, ClassLoader classLoader) {
        if (beanManager == null) {
            return null;
        }
        try {
            Method findBeanMethod = (Method)WildFlySecurityManager.doUnchecked((PrivilegedExceptionAction)new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Method m = AbstractArtifactFactory.class.getDeclaredMethod("findBean", String.class, BeanManager.class, ClassLoader.class);
                    m.setAccessible(true);
                    return m;
                }
            });
            Object result = findBeanMethod.invoke(null, ref, beanManager, classLoader);
            BatchLogger.LOGGER.tracef("Found bean: %s", result);
            return (Bean)result;
        }
        catch (Exception e) {
            BatchLogger.LOGGER.tracef("Looking up bean reference for '%s'", ref);
            Set beans = beanManager.getBeans(ref);
            Bean bean = beanManager.resolve(beans);
            if (bean != null) {
                BatchLogger.LOGGER.tracef("Found bean '%s' for reference '%s'", bean, ref);
            } else {
                BatchLogger.LOGGER.tracef("No bean found for reference '%s;'", ref);
            }
            return bean;
        }
    }

    private static class Holder {
        final Bean<?> bean;
        final CreationalContext<?> context;

        private Holder(Bean<?> bean, CreationalContext<?> context) {
            this.bean = bean;
            this.context = context;
        }

        boolean isDependent() {
            return Dependent.class.equals((Object)this.bean.getScope());
        }
    }
}

