/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonServer;
import io.vertx.proton.ProtonServerOptions;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;

public class MockServer {
    private ProtonServer server;

    public MockServer(Vertx vertx, Handler<ProtonConnection> connectionHandler) throws ExecutionException, InterruptedException {
        this(vertx, new ProtonServerOptions(), null, connectionHandler);
    }

    public MockServer(Vertx vertx, ProtonSaslAuthenticatorFactory authFactory, Handler<ProtonConnection> connectionHandler) throws ExecutionException, InterruptedException {
        this(vertx, new ProtonServerOptions(), authFactory, connectionHandler);
    }

    public MockServer(Vertx vertx, ProtonServerOptions options, ProtonSaslAuthenticatorFactory authFactory, Handler<ProtonConnection> connectionHandler) throws ExecutionException, InterruptedException {
        Objects.requireNonNull(options, "options must not be null");
        this.server = ProtonServer.create((Vertx)vertx, (ProtonServerOptions)options);
        this.server.connectHandler(connectionHandler);
        if (authFactory != null) {
            this.server.saslAuthenticatorFactory(authFactory);
        }
        AtomicReference failure = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        this.server.listen(0, res -> {
            if (!res.succeeded()) {
                failure.set(res.cause());
            }
            latch.countDown();
        });
        latch.await();
        if (failure.get() != null) {
            throw new ExecutionException((Throwable)failure.get());
        }
    }

    public int actualPort() {
        return this.server.actualPort();
    }

    public void close() {
        this.server.close();
    }

    ProtonServer getProtonServer() {
        return this.server;
    }
}

