/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import java.io.EOFException;
import java.util.Arrays;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.junit.Test;

public class MQTTSecurityTest
extends MQTTTestSupport {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testConnection() throws Exception {
        for (String version : Arrays.asList("3.1", "3.1.1")) {
            BlockingConnection connection = null;
            try {
                MQTT mqtt = this.createMQTTConnection("test-" + version, true);
                mqtt.setUserName(this.fullUser);
                mqtt.setPassword(this.fullPass);
                mqtt.setConnectAttemptsMax(1L);
                mqtt.setVersion(version);
                connection = mqtt.blockingConnection();
                connection.connect();
                BlockingConnection finalConnection = connection;
                MQTTSecurityTest.assertTrue((String)"Should be connected", (boolean)Wait.waitFor(() -> finalConnection.isConnected(), (long)5000L, (long)100L));
            }
            finally {
                if (connection == null || !connection.isConnected()) continue;
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L, expected=EOFException.class)
    public void testConnectionWithNullPassword() throws Exception {
        for (String version : Arrays.asList("3.1", "3.1.1")) {
            BlockingConnection connection = null;
            try {
                MQTT mqtt = this.createMQTTConnection("test-" + version, true);
                mqtt.setUserName(this.fullUser);
                mqtt.setPassword((String)null);
                mqtt.setConnectAttemptsMax(1L);
                mqtt.setVersion(version);
                connection = mqtt.blockingConnection();
                connection.connect();
                MQTTSecurityTest.fail((String)"Connect should fail");
            }
            finally {
                if (connection == null || !connection.isConnected()) continue;
                connection.disconnect();
            }
        }
    }
}

