/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.jms.persistence.config.PersistedConnectionFactory;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Before;
import org.junit.Test;

public class JMSConnectionFactoryConfigurationStorageTest
extends StorageManagerTestBase {
    private Map<String, PersistedConnectionFactory> mapExpectedCFs;

    public JMSConnectionFactoryConfigurationStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mapExpectedCFs = new HashMap<String, PersistedConnectionFactory>();
    }

    protected void addSetting(PersistedConnectionFactory setting) throws Exception {
        this.mapExpectedCFs.put(setting.getName(), setting);
        this.jmsJournal.storeConnectionFactory(setting);
    }

    @Test
    public void testSettings() throws Exception {
        this.createJMSStorage();
        ArrayList<String> transportConfigs = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            transportConfigs.add("c1-" + i);
            transportConfigs.add("c2-" + i);
        }
        ConnectionFactoryConfiguration config = new ConnectionFactoryConfigurationImpl().setName("some-name").setConnectorNames(transportConfigs);
        this.addSetting(new PersistedConnectionFactory(config));
        this.jmsJournal.stop();
        this.createJMSStorage();
        List cfs = this.jmsJournal.recoverConnectionFactories();
        JMSConnectionFactoryConfigurationStorageTest.assertEquals((long)1L, (long)cfs.size());
        JMSConnectionFactoryConfigurationStorageTest.assertEquals((Object)"some-name", (Object)((PersistedConnectionFactory)cfs.get(0)).getName());
        PersistedConnectionFactory cf1 = (PersistedConnectionFactory)cfs.get(0);
        JMSConnectionFactoryConfigurationStorageTest.assertEquals((long)10L, (long)cf1.getConfig().getConnectorNames().size());
        List configs = cf1.getConfig().getConnectorNames();
        int i = 0;
        int j = 0;
        while (i < 10) {
            JMSConnectionFactoryConfigurationStorageTest.assertEquals(configs.get(i), (Object)("c1-" + j));
            JMSConnectionFactoryConfigurationStorageTest.assertEquals(configs.get(i + 1), (Object)("c2-" + j));
            i += 2;
            ++j;
        }
    }

    @Test
    public void testSizeOfCF() throws Exception {
        String[] str = new String[5];
        for (int i = 0; i < 5; ++i) {
            str[i] = "str" + i;
        }
        ConnectionFactoryConfiguration config = new ConnectionFactoryConfigurationImpl().setName("some-name").setConnectorNames(new ArrayList()).setBindings(new String[]{""});
        int size = config.getEncodeSize();
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)size);
        config.encode(buffer);
        JMSConnectionFactoryConfigurationStorageTest.assertEquals((long)size, (long)buffer.writerIndex());
        PersistedConnectionFactory persistedCF = new PersistedConnectionFactory(config);
        size = persistedCF.getEncodeSize();
        buffer = ActiveMQBuffers.fixedBuffer((int)size);
        persistedCF.encode(buffer);
        JMSConnectionFactoryConfigurationStorageTest.assertEquals((long)size, (long)buffer.writerIndex());
    }

    @Test
    public void testSettingsWithConnectorConfigs() throws Exception {
        this.createJMSStorage();
        String[] str = new String[5];
        for (int i = 0; i < 5; ++i) {
            str[i] = "str" + i;
        }
        ArrayList connectorConfigs = new ArrayList();
        HashMap<String, Integer> liveParams = new HashMap<String, Integer>();
        liveParams.put("port", 5665);
        HashMap<String, Integer> backupParams = new HashMap<String, Integer>();
        backupParams.put("port", 5775);
        HashMap<String, Integer> liveParams2 = new HashMap<String, Integer>();
        liveParams2.put("port", 6665);
        ConnectionFactoryConfiguration config = new ConnectionFactoryConfigurationImpl().setName("some-name").setConnectorNames(connectorConfigs).setBindings(str).setCallTimeout(RandomUtil.randomPositiveLong());
        ArrayList<Pair> connectors = new ArrayList<Pair>();
        connectors.add(new Pair((Object)RandomUtil.randomString(), null));
        this.addSetting(new PersistedConnectionFactory(config));
        this.jmsJournal.stop();
        this.createJMSStorage();
        List cfs = this.jmsJournal.recoverConnectionFactories();
        JMSConnectionFactoryConfigurationStorageTest.assertEquals((long)1L, (long)cfs.size());
        JMSConnectionFactoryConfigurationStorageTest.assertEquals((Object)"some-name", (Object)((PersistedConnectionFactory)cfs.get(0)).getName());
        JMSConnectionFactoryConfigurationStorageTest.assertEquals((long)config.getCallTimeout(), (long)((PersistedConnectionFactory)cfs.get(0)).getConfig().getCallTimeout());
    }
}

