/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.timing.impl;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.common.resources.impl.EngineThreads;
import org.hibernate.search.engine.common.timing.spi.TimingSource;

public final class DefaultTimingSource
implements TimingSource {
    private static final long INVALID_TIME = -1L;
    private final EngineThreads threads;
    private ScheduledFuture<?> future;
    private volatile long currentTimeApproximation = -1L;

    public DefaultTimingSource(EngineThreads threads) {
        this.threads = threads;
    }

    @Override
    public long monotonicTimeEstimate() {
        long currentValue = this.currentTimeApproximation;
        if (currentValue == -1L) {
            throw new IllegalStateException("Timing source was not started");
        }
        return currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureTimeEstimateIsInitialized() {
        if (this.future != null) {
            return;
        }
        DefaultTimingSource defaultTimingSource = this;
        synchronized (defaultTimingSource) {
            if (this.future != null) {
                return;
            }
            this.future = this.threads.getTimingExecutor().scheduleAtFixedRate(new TriggerTask(), 5L, 5L, TimeUnit.MILLISECONDS);
            this.currentTimeApproximation = DefaultTimingSource.currentTime();
        }
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.currentTimeApproximation = -1L;
    }

    private static long currentTime() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    private class TriggerTask
    implements Runnable {
        private TriggerTask() {
        }

        @Override
        public void run() {
            DefaultTimingSource.this.currentTimeApproximation = DefaultTimingSource.currentTime();
        }
    }
}

