/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts.jandex;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.xts.XTSException;
import org.jboss.as.xts.jandex.CompensatableAnnotation;
import org.jboss.as.xts.jandex.OldCompensatableAnnotation;
import org.jboss.as.xts.jandex.StatelessAnnotation;
import org.jboss.as.xts.jandex.TransactionalAnnotation;
import org.jboss.as.xts.jandex.WebServiceAnnotation;

public class EndpointMetaData {
    private final TransactionalAnnotation transactionalAnnotation;
    private final CompensatableAnnotation compensatableAnnotation;
    private final OldCompensatableAnnotation oldCompensatableAnnotation;
    private final StatelessAnnotation statelessAnnotation;
    private final WebServiceAnnotation webServiceAnnotation;

    private EndpointMetaData(StatelessAnnotation statelessAnnotation, TransactionalAnnotation transactionalAnnotation, CompensatableAnnotation compensatableAnnotation, OldCompensatableAnnotation oldCompensatableAnnotation, WebServiceAnnotation webServiceAnnotation) {
        this.statelessAnnotation = statelessAnnotation;
        this.transactionalAnnotation = transactionalAnnotation;
        this.compensatableAnnotation = compensatableAnnotation;
        this.oldCompensatableAnnotation = oldCompensatableAnnotation;
        this.webServiceAnnotation = webServiceAnnotation;
    }

    public static EndpointMetaData build(DeploymentUnit unit, String endpoint) throws XTSException {
        TransactionalAnnotation transactionalAnnotation = TransactionalAnnotation.build(unit, endpoint);
        CompensatableAnnotation compensatableAnnotation = CompensatableAnnotation.build(unit, endpoint);
        OldCompensatableAnnotation oldCompensatableAnnotation = OldCompensatableAnnotation.build(unit, endpoint);
        StatelessAnnotation statelessAnnotation = StatelessAnnotation.build(unit, endpoint);
        WebServiceAnnotation webServiceAnnotation = WebServiceAnnotation.build(unit, endpoint);
        return new EndpointMetaData(statelessAnnotation, transactionalAnnotation, compensatableAnnotation, oldCompensatableAnnotation, webServiceAnnotation);
    }

    public WebServiceAnnotation getWebServiceAnnotation() {
        return this.webServiceAnnotation;
    }

    public boolean isWebservice() {
        return this.webServiceAnnotation != null;
    }

    public boolean isEJB() {
        return this.statelessAnnotation != null;
    }

    public boolean isBridgeEnabled() {
        return this.transactionalAnnotation != null;
    }

    public boolean isXTSEnabled() {
        return this.transactionalAnnotation != null || this.compensatableAnnotation != null || this.oldCompensatableAnnotation != null;
    }
}

