/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldReference;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexObjectFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexCompositeNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexField;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexObjectField;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexValueField;
import org.hibernate.search.backend.elasticsearch.gson.impl.GsonUtils;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.document.spi.NoOpDocumentElement;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDocumentObjectBuilder
implements DocumentElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchIndexModel model;
    private final ElasticsearchIndexCompositeNode schemaNode;
    private final JsonObject content;

    public ElasticsearchDocumentObjectBuilder(ElasticsearchIndexModel model) {
        this(model, (ElasticsearchIndexCompositeNode)model.root(), new JsonObject());
    }

    ElasticsearchDocumentObjectBuilder(ElasticsearchIndexModel model, ElasticsearchIndexCompositeNode schemaNode, JsonObject content) {
        this.model = model;
        this.schemaNode = schemaNode;
        this.content = content;
    }

    public <F> void addValue(IndexFieldReference<F> fieldReference, F value) {
        ElasticsearchIndexFieldReference elasticsearchFieldReference = (ElasticsearchIndexFieldReference)fieldReference;
        ElasticsearchIndexValueField fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        this.addValue(fieldSchemaNode, value);
    }

    public DocumentElement addObject(IndexObjectFieldReference fieldReference) {
        ElasticsearchIndexObjectFieldReference elasticsearchFieldReference = (ElasticsearchIndexObjectFieldReference)fieldReference;
        ElasticsearchIndexObjectField fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        JsonObject jsonObject = new JsonObject();
        return this.addObject(fieldSchemaNode, jsonObject);
    }

    public void addNullObject(IndexObjectFieldReference fieldReference) {
        ElasticsearchIndexObjectFieldReference elasticsearchFieldReference = (ElasticsearchIndexObjectFieldReference)fieldReference;
        ElasticsearchIndexObjectField fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        this.addObject(fieldSchemaNode, null);
    }

    public void addValue(String relativeFieldName, Object value) {
        String absoluteFieldPath = FieldPaths.compose((String)this.schemaNode.absolutePath(), (String)relativeFieldName);
        ElasticsearchIndexField node = (ElasticsearchIndexField)this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (node == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.eventContext());
        }
        this.addValueUnknownType(node.toValueField(), value);
    }

    public DocumentElement addObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        ElasticsearchIndexField fieldSchemaNode = (ElasticsearchIndexField)this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.eventContext());
        }
        ElasticsearchIndexObjectField objectFieldSchemaNode = fieldSchemaNode.toObjectField();
        JsonObject jsonObject = new JsonObject();
        this.addObject(objectFieldSchemaNode, jsonObject);
        return new ElasticsearchDocumentObjectBuilder(this.model, objectFieldSchemaNode, jsonObject);
    }

    public void addNullObject(String relativeFieldName) {
        String absoluteFieldPath = this.schemaNode.absolutePath(relativeFieldName);
        ElasticsearchIndexField fieldSchemaNode = (ElasticsearchIndexField)this.model.fieldOrNull(absoluteFieldPath, IndexFieldFilter.ALL);
        if (fieldSchemaNode == null) {
            throw log.unknownFieldForIndexing(absoluteFieldPath, this.model.eventContext());
        }
        ElasticsearchIndexObjectField objectFieldSchemaNode = fieldSchemaNode.toObjectField();
        this.addObject(objectFieldSchemaNode, null);
    }

    public JsonObject build() {
        return this.content;
    }

    private <F> void addValue(ElasticsearchIndexValueField<F> node, F value) {
        ElasticsearchIndexCompositeNode expectedParentNode = (ElasticsearchIndexCompositeNode)node.parent();
        this.checkTreeConsistency(expectedParentNode);
        if (IndexFieldInclusion.EXCLUDED.equals((Object)node.inclusion())) {
            return;
        }
        ElasticsearchIndexValueFieldType type = (ElasticsearchIndexValueFieldType)node.type();
        String jsonPropertyName = node.relativeName();
        if (!node.multiValued() && this.content.has(jsonPropertyName)) {
            throw log.multipleValuesForSingleValuedField(node.absolutePath());
        }
        GsonUtils.setOrAppendToArray(this.content, jsonPropertyName, type.codec().encode(value));
    }

    private void addValueUnknownType(ElasticsearchIndexValueField<?> node, Object value) {
        if (value == null) {
            this.addValue(node, null);
        } else {
            ElasticsearchIndexValueField<?> typeCheckedNode = node.withValueType(value.getClass(), this.model.eventContext());
            this.addValue(typeCheckedNode, value);
        }
    }

    private DocumentElement addObject(ElasticsearchIndexObjectField node, JsonObject value) {
        ElasticsearchIndexCompositeNode expectedParentNode = (ElasticsearchIndexCompositeNode)node.parent();
        this.checkTreeConsistency(expectedParentNode);
        if (IndexFieldInclusion.EXCLUDED.equals((Object)node.inclusion())) {
            return NoOpDocumentElement.get();
        }
        String jsonPropertyName = node.relativeName();
        if (!node.multiValued() && this.content.has(jsonPropertyName)) {
            throw log.multipleValuesForSingleValuedField(node.absolutePath());
        }
        GsonUtils.setOrAppendToArray(this.content, jsonPropertyName, (JsonElement)value);
        if (value == null) {
            return NoOpDocumentElement.get();
        }
        return new ElasticsearchDocumentObjectBuilder(this.model, node, value);
    }

    private void checkTreeConsistency(ElasticsearchIndexCompositeNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw log.invalidFieldForDocumentElement(expectedParentNode.absolutePath(), this.schemaNode.absolutePath());
        }
    }
}

