/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.DynamicTemplate;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.LeafValidators;
import org.hibernate.search.backend.elasticsearch.validation.impl.PropertyMappingValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;

class DynamicTemplateValidator
implements Validator<DynamicTemplate> {
    private final Validator<JsonElement> extraAttributeValidator = new JsonElementValidator(new JsonElementEquivalence());
    private final Validator<PropertyMapping> propertyMappingValidator = new PropertyMappingValidator();

    DynamicTemplateValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ValidationErrorCollector errorCollector, DynamicTemplate expected, DynamicTemplate actual) {
        if (expected == null) {
            errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.dynamicTemplateUnexpected());
            return;
        }
        if (actual == null) {
            errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.dynamicTemplateMissing());
            return;
        }
        LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.DYNAMIC_TEMPLATE_ATTRIBUTE, "match_mapping_type", expected.getMatchMappingType(), actual.getMatchMappingType());
        LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.DYNAMIC_TEMPLATE_ATTRIBUTE, "path_match", expected.getPathMatch(), actual.getPathMatch());
        this.extraAttributeValidator.validateAllIncludingUnexpected(errorCollector, ValidationContextType.DYNAMIC_TEMPLATE_ATTRIBUTE, expected.getExtraAttributes(), actual.getExtraAttributes());
        errorCollector.push(ValidationContextType.DYNAMIC_TEMPLATE_ATTRIBUTE, "mapping");
        try {
            this.propertyMappingValidator.validate(errorCollector, expected.getMapping(), actual.getMapping());
        }
        finally {
            errorCollector.pop();
        }
    }
}

