/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;

class JsonElementValidator
implements Validator<JsonElement> {
    private final JsonElementEquivalenceProvider equivalenceProvider;

    JsonElementValidator(JsonElementEquivalence equivalence) {
        this((String ignored) -> equivalence);
    }

    JsonElementValidator(JsonElementEquivalenceProvider equivalenceProvider) {
        this.equivalenceProvider = equivalenceProvider;
    }

    @Override
    public void validate(ValidationErrorCollector theErrorCollector, JsonElement expected, JsonElement actual) {
        JsonElementEquivalence parameterEquivalence = this.equivalenceProvider.get(theErrorCollector.getCurrentName());
        if (!parameterEquivalence.isEquivalent(expected, actual)) {
            theErrorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidValue(expected, actual));
        }
    }

    public static interface JsonElementEquivalenceProvider {
        public JsonElementEquivalence get(String var1);
    }
}

