/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.tx;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;

public class TransactionalBatch<E extends RuntimeException>
implements TransactionBatch {
    private final Function<Throwable, E> exceptionTransformer;
    private final Transaction tx;
    private final AtomicInteger count = new AtomicInteger(0);
    private volatile boolean active = true;

    public TransactionalBatch(Transaction tx, Function<Throwable, E> exceptionTransformer) {
        this.tx = tx;
        this.exceptionTransformer = exceptionTransformer;
    }

    @Override
    public Transaction getTransaction() {
        return this.tx;
    }

    @Override
    public TransactionBatch interpose() {
        this.count.incrementAndGet();
        return this;
    }

    public void discard() {
        this.active = false;
    }

    public Batch.State getState() {
        try {
            switch (this.tx.getStatus()) {
                case 0: {
                    if (this.active) {
                        return Batch.State.ACTIVE;
                    }
                }
                case 1: {
                    return Batch.State.DISCARDED;
                }
            }
            return Batch.State.CLOSED;
        }
        catch (SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
    }

    public void close() {
        if (this.count.getAndDecrement() == 0) {
            try {
                switch (this.tx.getStatus()) {
                    case 0: {
                        if (this.active) {
                            try {
                                this.tx.commit();
                                break;
                            }
                            catch (RollbackException e) {
                                throw new IllegalStateException(e);
                            }
                            catch (HeuristicMixedException | HeuristicRollbackException e) {
                                throw (RuntimeException)this.exceptionTransformer.apply(e);
                            }
                        }
                    }
                    case 1: {
                        this.tx.rollback();
                    }
                }
            }
            catch (SystemException e) {
                throw (RuntimeException)this.exceptionTransformer.apply(e);
            }
        }
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionalBatch)) {
            return false;
        }
        TransactionalBatch batch = (TransactionalBatch)object;
        return this.tx.equals(batch.tx);
    }

    public String toString() {
        return String.format("%s[%d]", this.tx, this.count.get());
    }
}

