/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.DeploymentHandler;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithListValue;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeployArchiveCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DisableCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.ListCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.UndeployArchiveCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.UndeployCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

@Deprecated
public class UndeployHandler
extends DeploymentHandler {
    private final ArgumentWithoutValue l;
    private final ArgumentWithoutValue path;
    private final ArgumentWithValue name;
    private final ArgumentWithListValue serverGroups;
    private final ArgumentWithoutValue allRelevantServerGroups;
    private final ArgumentWithoutValue keepContent;
    private final ArgumentWithValue script;
    private AccessRequirement listPermission;
    private AccessRequirement mainRemovePermission;
    private AccessRequirement undeployPermission;

    public UndeployHandler(CommandContext ctx) {
        super(ctx, "undeploy", true);
        DefaultOperationRequestAddress requiredAddress = new DefaultOperationRequestAddress();
        requiredAddress.toNodeType("deployment");
        this.addRequiredPath(requiredAddress);
        this.l = new ArgumentWithoutValue(this, "-l");
        this.l.setExclusive(true);
        this.l.setAccessRequirement(this.listPermission);
        AccessRequirement removeOrUndeployPermission = AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.mainRemovePermission).requirement(this.undeployPermission).build();
        this.name = new ArgumentWithValue((CommandHandlerWithArguments)this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                ParsedCommandLine args = ctx.getParsedCommandLine();
                try {
                    if (UndeployHandler.this.path.isPresent(args)) {
                        return -1;
                    }
                }
                catch (CommandFormatException e) {
                    return -1;
                }
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getDeployments(ctx.getModelControllerClient());
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }, 0, "--name");
        this.name.addCantAppearAfter(this.l);
        this.name.setAccessRequirement(removeOrUndeployPermission);
        this.allRelevantServerGroups = new ArgumentWithoutValue(this, "--all-relevant-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.allRelevantServerGroups.addRequiredPreceding(this.name);
        this.allRelevantServerGroups.setAccessRequirement(this.undeployPermission);
        this.serverGroups = new ArgumentWithListValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                List<String> allGroups;
                String deploymentName = UndeployHandler.this.name.getValue(ctx.getParsedCommandLine());
                try {
                    allGroups = Util.getServerGroupsReferencingDeployment(deploymentName, ctx.getModelControllerClient());
                }
                catch (CommandLineException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
                return allGroups;
            }
        }, "--server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.serverGroups.addRequiredPreceding(this.name);
        this.serverGroups.setAccessRequirement(this.undeployPermission);
        this.serverGroups.addCantAppearAfter(this.allRelevantServerGroups);
        this.allRelevantServerGroups.addCantAppearAfter(this.serverGroups);
        this.keepContent = new ArgumentWithoutValue(this, "--keep-content");
        this.keepContent.addRequiredPreceding(this.name);
        this.keepContent.setAccessRequirement(this.undeployPermission);
        FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        this.path = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, "--path");
        this.path.addCantAppearAfter(this.l);
        this.path.setAccessRequirement(removeOrUndeployPermission);
        this.script = new ArgumentWithValue(this, "--script");
        this.script.addRequiredPreceding(this.path);
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        Permissions permissions = new Permissions(ctx);
        this.listPermission = permissions.getListPermission();
        this.mainRemovePermission = permissions.getMainRemovePermission();
        this.undeployPermission = permissions.getUndeployPermission();
        return AccessRequirements.undeployLegacyAccess(permissions).apply(ctx);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        File f;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean l = this.l.isPresent(args);
        if (!args.hasProperties() || l) {
            try {
                ListCommand.listDeployments(ctx, l);
            }
            catch (CommandException ex) {
                throw new CommandLineException(ex.getLocalizedMessage());
            }
            return;
        }
        String path = this.path.getValue(args);
        if (path != null && DeployArchiveCommand.isCliArchive(f = new File(path))) {
            UndeployArchiveCommand command = new UndeployArchiveCommand(ctx);
            command.file = f;
            command.script = this.script.getValue(args);
            try {
                command.execute(ctx);
            }
            catch (CommandException ex) {
                throw new CommandLineException(ex.getLocalizedMessage());
            }
            return;
        }
        String name = this.name.getValue(ctx.getParsedCommandLine());
        if (name == null) {
            try {
                ListCommand.listDeployments(ctx, l);
            }
            catch (CommandException ex) {
                throw new CommandLineException(ex.getLocalizedMessage());
            }
            return;
        }
        UndeployCommand command = null;
        boolean keepContent = this.keepContent.isPresent(args);
        command = keepContent ? new DisableCommand(ctx) : new UndeployCommand(ctx);
        command.allRelevantServerGroups = this.allRelevantServerGroups.isPresent(args);
        ModelNode headersNode = this.headers.toModelNode(ctx);
        if (headersNode != null && headersNode.getType() != ModelType.OBJECT) {
            throw new CommandFormatException("--headers option has wrong value '" + headersNode + "'");
        }
        command.headers = headersNode;
        if (name != null) {
            command.name = name;
        }
        command.serverGroups = this.serverGroups.getValue(args);
        try {
            command.execute(ctx);
        }
        catch (CommandException ex) {
            throw new CommandLineException(ex.getLocalizedMessage());
        }
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        File f;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String p = this.path.getValue(args);
        if (p != null && DeployArchiveCommand.isCliArchive(f = new File(p))) {
            UndeployArchiveCommand command = new UndeployArchiveCommand(ctx);
            command.file = f;
            command.script = this.script.getValue(args);
            return command.buildRequest(ctx);
        }
        if (this.name == null) {
            throw new CommandFormatException("Deployment name is missing.");
        }
        UndeployCommand command = null;
        boolean keepContent = this.keepContent.isPresent(args);
        command = keepContent ? new DisableCommand(ctx) : new UndeployCommand(ctx);
        String name = this.name.getValue(ctx.getParsedCommandLine());
        command.allRelevantServerGroups = this.allRelevantServerGroups.isPresent(args);
        if (name != null) {
            command.name = name;
        }
        command.serverGroups = this.serverGroups.getValue(args);
        return command.buildRequest(ctx);
    }
}

