/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.impl.ElytronMessages;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.x500.X500;

public final class KeyStoreCredentialSource
implements CredentialSource {
    private final SecurityFactory<KeyStore.Entry> entryFactory;

    public KeyStoreCredentialSource(KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        Assert.checkNotNullParam((String)"keyStore", (Object)keyStore);
        Assert.checkNotNullParam((String)"alias", (Object)alias);
        this.entryFactory = () -> keyStore.getEntry(alias, protectionParameter);
    }

    public KeyStoreCredentialSource(SecurityFactory<KeyStore.Entry> entryFactory) {
        Assert.checkNotNullParam((String)"entryFactory", entryFactory);
        this.entryFactory = entryFactory;
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        return this.getCredential(credentialType, algorithmName, parameterSpec) != null ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        try {
            SecretKeyCredential credential;
            KeyStore.Entry entry = (KeyStore.Entry)this.entryFactory.create();
            if (entry == null) {
                return null;
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                X509Certificate[] certificateChain = X500.asX509CertificateArray((Object[])privateKeyEntry.getCertificateChain());
                X509Certificate firstCert = certificateChain[0];
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                if (credentialType.isAssignableFrom(X509CertificateChainPrivateCredential.class)) {
                    credential = new X509CertificateChainPrivateCredential(privateKey, certificateChain);
                    return (C)credential.castAs(credentialType, algorithmName, parameterSpec);
                } else if (credentialType.isAssignableFrom(X509CertificateChainPublicCredential.class)) {
                    credential = new X509CertificateChainPublicCredential(certificateChain);
                    return (C)credential.castAs(credentialType, algorithmName, parameterSpec);
                } else if (credentialType.isAssignableFrom(PublicKeyCredential.class)) {
                    credential = new PublicKeyCredential(firstCert.getPublicKey());
                    return (C)credential.castAs(credentialType, algorithmName, parameterSpec);
                } else {
                    if (!credentialType.isAssignableFrom(KeyPairCredential.class)) return null;
                    credential = new KeyPairCredential(new KeyPair(firstCert.getPublicKey(), privateKey));
                }
                return (C)credential.castAs(credentialType, algorithmName, parameterSpec);
            } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
                KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
                X509Certificate certificate = (X509Certificate)trustedCertificateEntry.getTrustedCertificate();
                if (!credentialType.isAssignableFrom(PublicKeyCredential.class)) return null;
                credential = new PublicKeyCredential(certificate.getPublicKey());
                return (C)credential.castAs(credentialType, algorithmName, parameterSpec);
            } else if (entry instanceof KeyStore.SecretKeyEntry) {
                KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
                if (!credentialType.isAssignableFrom(SecretKeyCredential.class)) return null;
                credential = new SecretKeyCredential(secretKeyEntry.getSecretKey());
                return (C)credential.castAs(credentialType, algorithmName, parameterSpec);
            } else {
                if (!(entry instanceof PasswordEntry)) return null;
                PasswordEntry passwordEntry = (PasswordEntry)entry;
                if (!credentialType.isAssignableFrom(PasswordCredential.class)) return null;
                credential = new PasswordCredential(passwordEntry.getPassword());
            }
            return (C)credential.castAs(credentialType, algorithmName, parameterSpec);
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
    }
}

