/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.ProtocolSocketBinding;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.service.ClusteringRequirement;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.common.net.Inet;

public class EJBRemotingConnectorClientMappingsEntryProviderService
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<Map.Entry<String, List<ClientMapping>>> {
    private static final ServiceName BASE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "remote", "client-mappings"});
    private volatile SupplierDependency<ProtocolSocketBinding> remotingConnectorInfo;
    private final String containerName;
    private final String connectorName;
    private volatile SupplierDependency<Group> group;

    public EJBRemotingConnectorClientMappingsEntryProviderService(String containerName, String connectorName) {
        super(BASE_NAME.append(new String[]{connectorName}));
        this.containerName = containerName;
        this.connectorName = connectorName;
    }

    public ServiceConfigurator configure(OperationContext context) {
        this.group = new ServiceSupplierDependency(ClusteringRequirement.GROUP.getServiceName(context, this.containerName));
        this.remotingConnectorInfo = new ServiceSupplierDependency(context.getCapabilityServiceName("org.wildfly.remoting.connector", this.connectorName, ProtocolSocketBinding.class));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer entry = new CompositeDependency(new Dependency[]{this.group, this.remotingConnectorInfo}).register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(entry, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public Map.Entry<String, List<ClientMapping>> get() {
        return new AbstractMap.SimpleImmutableEntry<String, List<ClientMapping>>(((Group)this.group.get()).getLocalMember().getName(), this.getClientMappings());
    }

    List<ClientMapping> getClientMappings() {
        ArrayList<ClientMapping> ret = new ArrayList<ClientMapping>();
        ProtocolSocketBinding info = (ProtocolSocketBinding)this.remotingConnectorInfo.get();
        if (info.getSocketBinding().getClientMappings() != null && !info.getSocketBinding().getClientMappings().isEmpty()) {
            ret.addAll(info.getSocketBinding().getClientMappings());
        } else {
            InetAddress clientNetworkAddress;
            InetAddress destination = info.getSocketBinding().getAddress();
            String destinationName = Inet.toURLString((InetAddress)destination, (boolean)true);
            try {
                clientNetworkAddress = destination instanceof Inet4Address ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName("::");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ClientMapping defaultClientMapping = new ClientMapping(clientNetworkAddress, 0, destinationName, info.getSocketBinding().getAbsolutePort());
            ret.add(defaultClientMapping);
        }
        return ret;
    }
}

