/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;

final class AutoValue_DoubleExemplarData
extends DoubleExemplarData {
    private final Attributes filteredAttributes;
    private final long epochNanos;
    private final SpanContext spanContext;
    private final double value;

    AutoValue_DoubleExemplarData(Attributes filteredAttributes, long epochNanos, SpanContext spanContext, double value) {
        if (filteredAttributes == null) {
            throw new NullPointerException("Null filteredAttributes");
        }
        this.filteredAttributes = filteredAttributes;
        this.epochNanos = epochNanos;
        if (spanContext == null) {
            throw new NullPointerException("Null spanContext");
        }
        this.spanContext = spanContext;
        this.value = value;
    }

    @Override
    public Attributes getFilteredAttributes() {
        return this.filteredAttributes;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public String toString() {
        return "DoubleExemplarData{filteredAttributes=" + this.filteredAttributes + ", epochNanos=" + this.epochNanos + ", spanContext=" + this.spanContext + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DoubleExemplarData) {
            DoubleExemplarData that = (DoubleExemplarData)o;
            return this.filteredAttributes.equals(that.getFilteredAttributes()) && this.epochNanos == that.getEpochNanos() && this.spanContext.equals(that.getSpanContext()) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.getValue());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filteredAttributes.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        h$ *= 1000003;
        h$ ^= this.spanContext.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value));
    }
}

