/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.util;

import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class Indices {
    public static final DotName INHERITED_NAME = DotName.createSimple((String)Inherited.class.getName());
    public static final Function<ClassInfo, String> CLASS_INFO_TO_FQCN = new Function<ClassInfo, String>(){

        @Override
        public String apply(ClassInfo input) {
            return input.name().toString();
        }
    };
    public static final Predicate<ClassInfo> ANNOTATION_PREDICATE = new Predicate<ClassInfo>(){

        @Override
        public boolean test(ClassInfo input) {
            return Indices.isAnnotation(input);
        }
    };
    private static final int ANNOTATION = 8192;

    private Indices() {
    }

    public static boolean isAnnotation(ClassInfo clazz) {
        return (clazz.flags() & 0x2000) != 0;
    }

    public static List<ClassInfo> getAnnotatedClasses(List<AnnotationInstance> instances) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        for (AnnotationInstance instance : instances) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            result.add((ClassInfo)target);
        }
        return result;
    }
}

