/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.converters.uni;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class UniToMultiPublisher<T>
implements Publisher<T> {
    private final Uni<T> uni;

    public UniToMultiPublisher(Uni<T> uni) {
        this.uni = uni;
    }

    public void subscribe(Subscriber<? super T> downstream) {
        downstream.onSubscribe(new UniToMultiSubscription(this.uni, downstream));
    }

    private static class UniToMultiSubscription<T>
    implements UniSubscription,
    Subscription,
    UniSubscriber<T>,
    ContextSupport {
        private final Uni<T> uni;
        private final Subscriber<? super T> downstream;
        private volatile UniSubscription upstream;
        private volatile State state = State.INIT;
        private static final AtomicReferenceFieldUpdater<UniToMultiSubscription, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(UniToMultiSubscription.class, State.class, "state");

        private UniToMultiSubscription(Uni<T> uni, Subscriber<? super T> downstream) {
            this.uni = uni;
            this.downstream = downstream;
        }

        @Override
        public Context context() {
            if (this.downstream instanceof ContextSupport) {
                return ((ContextSupport)this.downstream).context();
            }
            return Context.empty();
        }

        @Override
        public void cancel() {
            if (this.upstream != null) {
                this.upstream.cancel();
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.downstream.onError((Throwable)new IllegalArgumentException("Invalid request"));
                return;
            }
            if (STATE_UPDATER.compareAndSet(this, State.INIT, State.UNI_REQUESTED)) {
                AbstractUni.subscribe(this.uni, this);
            }
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (this.upstream == null) {
                this.upstream = subscription;
            } else {
                subscription.cancel();
                this.downstream.onError((Throwable)new IllegalStateException("Invalid subscription state - already have a subscription for upstream"));
            }
        }

        @Override
        public void onItem(T item) {
            if (STATE_UPDATER.compareAndSet(this, State.UNI_REQUESTED, State.DONE)) {
                if (item != null) {
                    this.downstream.onNext(item);
                }
                this.downstream.onComplete();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (STATE_UPDATER.compareAndSet(this, State.UNI_REQUESTED, State.DONE)) {
                this.downstream.onError(failure);
            }
        }

        static enum State {
            INIT,
            UNI_REQUESTED,
            DONE;

        }
    }
}

