/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class MultiConvert<T> {
    private final Multi<T> upstream;

    public MultiConvert(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <R> R with(Function<Multi<T>, R> converter) {
        ParameterValidation.nonNull(converter, "converter");
        return converter.apply(this.upstream);
    }

    @CheckReturnValue
    public Publisher<T> toPublisher() {
        return this.upstream;
    }
}

