/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAndGroupIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.tuples.Functions;
import io.smallrye.mutiny.tuples.Tuple9;
import io.smallrye.mutiny.tuples.Tuples;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class UniAndGroup9<T1, T2, T3, T4, T5, T6, T7, T8, T9>
extends UniAndGroupIterable<T1> {
    public UniAndGroup9(Uni<? extends T1> source, Uni<? extends T2> o1, Uni<? extends T3> o2, Uni<? extends T4> o3, Uni<? extends T5> o4, Uni<? extends T6> o5, Uni<? extends T7> o6, Uni<? extends T8> o7, Uni<? extends T9> o8) {
        super(source, Arrays.asList(o1, o2, o3, o4, o5, o6, o7, o8));
    }

    @CheckReturnValue
    public UniAndGroup9<T1, T2, T3, T4, T5, T6, T7, T8, T9> collectFailures() {
        super.collectFailures();
        return this;
    }

    @CheckReturnValue
    public Uni<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> asTuple() {
        return this.combine(Tuple9::of);
    }

    @CheckReturnValue
    public <O> Uni<O> combinedWith(Functions.Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, O> combinator) {
        Functions.Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, O> actual = Infrastructure.decorate(ParameterValidation.nonNull(combinator, "combinator"));
        return this.combine(actual);
    }

    private <O> Uni<O> combine(Functions.Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, O> combinator) {
        Function<List, Object> function = list -> {
            Tuples.ensureArity(list, 9);
            return combinator.apply(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5), list.get(6), list.get(7), list.get(8));
        };
        return super.combinedWith(function);
    }
}

