/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongFunction;

public class MultiOnRequestCall<T>
extends AbstractMultiOperator<T, T> {
    private final LongFunction<Uni<?>> mapper;

    public MultiOnRequestCall(Multi<? extends T> upstream, LongFunction<Uni<?>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "consumer");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnRequestCallOperator(ParameterValidation.nonNull(downstream, "downstream")));
    }

    class MultiOnRequestCallOperator
    extends MultiOperatorProcessor<T, T> {
        private final AtomicReference<Cancellable> cancellable;
        private final AtomicLong requests;

        public MultiOnRequestCallOperator(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.cancellable = new AtomicReference();
            this.requests = new AtomicLong();
        }

        @Override
        public void request(long numberOfItems) {
            ParameterValidation.positive(numberOfItems, "requests");
            if (this.requests.addAndGet(numberOfItems) < 0L) {
                throw new IllegalArgumentException("The amount of pending requests exceeded Long.MAX_VALUE");
            }
            this.cancellable.set(this.execute(numberOfItems).subscribe().with(ignored -> {
                this.cancellable.set(null);
                super.request(numberOfItems);
            }, throwable -> {
                this.cancellable.set(null);
                super.onFailure((Throwable)throwable);
            }));
        }

        @Override
        public void onItem(T item) {
            this.requests.decrementAndGet();
            super.onItem(item);
        }

        @Override
        public void cancel() {
            Cancellable uni = this.cancellable.getAndSet(null);
            if (uni != null) {
                uni.cancel();
            }
        }

        private Uni<?> execute(long numberOfItems) {
            try {
                return ParameterValidation.nonNull((Uni)MultiOnRequestCall.this.mapper.apply(numberOfItems), "uni");
            }
            catch (Throwable err) {
                return Uni.createFrom().failure(err);
            }
        }
    }
}

